/*
 * Decompiled with CFR 0.152.
 */
package asteroid.printer;

import asteroid.model.Angle;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.printer.APrinter;
import java.io.PrintStream;

public class Direction
extends APrinter {
    private GameModel mModel;
    private int mShipX;
    private int mShipY;
    private int mShotX;
    private int mShotY;

    public Direction(GameModel gameModel, String string) {
        super(string);
        this.mModel = gameModel;
    }

    public Direction(GameModel gameModel, PrintStream printStream) {
        super(printStream);
        this.mModel = gameModel;
    }

    public void forShip(Ship ship) {
        this.mShipX = ship.getX8();
        this.mShipY = ship.getY8();
    }

    public void forShot(Shot shot) {
        if (shot.getIndex() == 0) {
            if (shot.getCreate() > 0) {
                this.mShotX = shot.getX8();
                this.mShotY = shot.getY8();
            }
            if (shot.isVisible() && shot.getModify() == 16) {
                this.mOut.print("A:");
                this.mOut.printByte(Angle.sDirection);
                this.mOut.print(",");
                this.mOut.print(this.mShotX - this.mShipX);
                this.mOut.print(",");
                this.mOut.print(this.mShotY - this.mShipY);
                this.mOut.println();
            }
        }
    }

    public void print() {
        this.mModel.forShip(this);
        this.mModel.forAllShots(this);
    }
}

