/*
 * Decompiled with CFR 0.152.
 */
package asteroid.printer;

import asteroid.model.AFlyable;
import asteroid.model.Asteroid;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;

class Remember {
    boolean mActive;
    boolean mExplosion;
    int mMoveX8;
    int mMoveY8;
    int mX8;
    int mY8;
    int mZ;
    int mType;

    Remember() {
    }

    public boolean isActive() {
        return this.mActive;
    }

    public boolean isExplosion() {
        return this.mActive && this.mExplosion;
    }

    public void saveAsteroid(Asteroid asteroid) {
        this.saveFlyable(asteroid);
        this.mActive = asteroid.isVisible();
        this.mExplosion = asteroid.isExplosion();
        this.mType = asteroid.getType();
    }

    public void saveFlyable(AFlyable aFlyable) {
        this.mX8 = aFlyable.getX8();
        this.mY8 = aFlyable.getY8();
        this.mZ = aFlyable.getZ();
        this.mMoveX8 = aFlyable.getMoveX8();
        this.mMoveY8 = aFlyable.getMoveY8();
    }

    public void saveShip(Ship ship) {
        this.saveFlyable(ship);
        this.mActive = ship.isVisible();
        this.mType = ship.getType();
    }

    public void saveShot(Shot shot) {
        this.saveFlyable(shot);
        this.mActive = shot.isVisible();
    }

    public void saveUfo(Ufo ufo) {
        this.saveFlyable(ufo);
        this.mActive = ufo.isVisible();
        this.mExplosion = ufo.isExplosion();
        this.mType = ufo.getType();
    }

    public boolean isVisible() {
        return this.mActive && !this.mExplosion;
    }
}

