/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy;

import asteroid.model.AFlyable;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ufo;
import asteroid.strategy.AStrategie;

public class Charge
extends AStrategie {
    private int mDirectionNearest;
    private int mDist;
    private boolean mFire;
    private int mKey;

    public Charge(GameModel gameModel) {
        super(gameModel);
    }

    public void cleanup() {
    }

    private int getFire() {
        return this.mFire ? 2 : 0;
    }

    public void forAsteroid(Asteroid asteroid) {
        if (asteroid.isVisible()) {
            int n;
            asteroid.setDirection(this.mModel.getShip(), Angle.sForward);
            int n2 = asteroid.getDirection();
            if (Angle.distRot(n2 - Angle.sDirection) < 2) {
                this.mFire = true;
            }
            if ((n = asteroid.getDistance2(this.mModel.getShip())) < this.mDist) {
                this.mDist = n;
                this.mDirectionNearest = n2;
            }
        }
    }

    public void forUfo(Ufo ufo) {
        if (ufo.isVisible()) {
            int n;
            ufo.setDirection(this.mModel.getShip(), Angle.sForward);
            int n2 = ufo.getDirection();
            if (Angle.distRot(n2 - Angle.sDirection) < 2) {
                this.mFire = true;
            }
            if ((n = ufo.getDistance2(this.mModel.getShip())) < this.mDist) {
                this.mDist = n;
                this.mDirectionNearest = n2;
            }
        }
    }

    public int getKey() {
        return this.mModel.isShipVisible() ? this.mKey : 0;
    }

    void print(AFlyable aFlyable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Ship (").append(this.mModel.getShip().getX8()).append(",").append(this.mModel.getShip().getY8()).append(":").append(Angle.sDirection).append(")");
        stringBuffer.append(" Flyable (").append(aFlyable.getX8()).append(",").append(aFlyable.getY8()).append(")");
        stringBuffer.append(" Move (").append(aFlyable.getMoveX8()).append(",").append(aFlyable.getMoveY8()).append(")");
        stringBuffer.append(" angle=").append(this.mDirectionNearest);
        stringBuffer.append(" v2=").append(aFlyable.getVelocity8());
        System.out.println(stringBuffer.toString());
    }

    public void refresh() {
        if (this.mModel.getShip().isVisible()) {
            this.mDirectionNearest = Angle.sDirection;
            this.mDist = Integer.MAX_VALUE;
            this.mFire = false;
            this.mModel.forUfo(this);
            this.mModel.forAllAsteroids(this);
            this.mKey = this.getRot() | this.getFire();
        }
    }

    private int getRot() {
        int n = Angle.signRot(this.mDirectionNearest - Angle.sDirection);
        if (n > 0) {
            return 16;
        }
        if (n < 0) {
            return 8;
        }
        return 0;
    }
}

