/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy;

import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Magazine;
import asteroid.model.Ufo;
import asteroid.strategy.AStrategie;

public class ChargeSingle
extends AStrategie {
    private int mDirection;
    private int mDirectionNext;
    private int mFill;
    private Magazine mMagazine = new Magazine();
    private AEnemy[] mNearest = new AEnemy[28];

    public ChargeSingle(GameModel gameModel) {
        super(gameModel);
    }

    private void addNearest(AEnemy aEnemy) {
        for (int i = 0; i < this.mFill; ++i) {
            AEnemy aEnemy2 = this.mNearest[i];
            if (aEnemy.getTime() > aEnemy2.getTime()) continue;
            System.arraycopy(this.mNearest, i, this.mNearest, i + 1, 27 - i);
            this.mNearest[i] = aEnemy;
            ++this.mFill;
            return;
        }
        this.mNearest[this.mFill++] = aEnemy;
    }

    public void cleanup() {
        this.mMagazine.cleanup(this.mModel);
    }

    public void forAsteroid(Asteroid asteroid) {
        this.forEnemy(asteroid);
    }

    private void forEnemy(AEnemy aEnemy) {
        if (aEnemy.isVisible()) {
            aEnemy.setDirection(this.mModel.getShip(), Angle.sForward);
            this.addNearest(aEnemy);
        }
    }

    public void forUfo(Ufo ufo) {
        this.forEnemy(ufo);
    }

    public int getKey() {
        if (this.mModel.isShipVisible()) {
            return this.getRot() | this.mMagazine.getKey();
        }
        return 0;
    }

    private int getNextDirection(AEnemy aEnemy) {
        int n = aEnemy.getX8() - this.mModel.getShip().getX8();
        int n2 = aEnemy.getY8() - this.mModel.getShip().getY8();
        if (n * aEnemy.getMoveY8() - n2 * aEnemy.getMoveX8() > 0) {
            return aEnemy.getDirection() + 2;
        }
        return aEnemy.getDirection() - 2;
    }

    public void refresh() {
        if (this.mModel.getShip().isVisible()) {
            AEnemy aEnemy;
            int n;
            this.mDirection = Angle.sDirection;
            this.mMagazine.prepareFire();
            this.mFill = 0;
            this.mModel.forUfo(this);
            this.mModel.forAllAsteroids(this);
            this.mDirectionNext = 99999;
            for (n = 0; n < this.mFill; ++n) {
                aEnemy = this.mNearest[n];
                if (aEnemy.getTime() > 60.0 || this.mMagazine.isTaget(aEnemy) && !aEnemy.canFire()) continue;
                if (Angle.distRot(aEnemy.getDirection() - Angle.sDirection) < 2) {
                    if (!aEnemy.canFire()) {
                        this.mMagazine.addFire(aEnemy, false);
                        if (aEnemy.getID() == 27 || aEnemy.canFire()) continue;
                        aEnemy.initFire();
                        switch (aEnemy.getZ()) {
                            case 0: {
                                if (!this.mMagazine.isFire()) break;
                                this.mDirectionNext = this.getNextDirection(aEnemy);
                                break;
                            }
                            case 15: {
                                if (!this.mMagazine.isFire()) break;
                                this.mDirectionNext = this.getNextDirection(aEnemy);
                                break;
                            }
                        }
                        continue;
                    }
                    this.mMagazine.addFire(aEnemy, true);
                    if (!this.mMagazine.isFire()) continue;
                    aEnemy.decFire();
                    this.mDirectionNext = this.getNextDirection(aEnemy);
                    continue;
                }
                if (this.mDirectionNext != 99999) continue;
                this.mDirectionNext = aEnemy.getDirection();
            }
            if (this.mDirectionNext == 99999) {
                int n2 = this.mDirectionNext = this.mFill > 0 ? this.mNearest[0].getDirection() : this.mDirection;
            }
            if (this.mFill < 5 && this.mFill > 0) {
                for (n = 0; n < this.mFill; ++n) {
                    aEnemy = this.mNearest[n];
                    if (Angle.distRot(aEnemy.getDirection() - Angle.sDirection) >= 1) continue;
                    this.mMagazine.addFire(aEnemy, true);
                }
            }
        }
    }

    private int getRot() {
        int n = Angle.signRot(this.mDirectionNext - this.mDirection);
        if (n > 1) {
            return 16;
        }
        if (n < -1) {
            return 8;
        }
        return 0;
    }
}

