/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy;

import asteroid.Operation;
import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.Ship;

public class Distance {
    private double mAlpha;
    private int mDX0;
    private int mDY0;
    private AEnemy mEnemy;
    private boolean mLeft;
    private int mTimeMin2;
    private int mDistMin2;
    private int mTimeShot;
    private int mTimeEnemy;
    private int mTimeWait;

    public Distance(AEnemy aEnemy) {
        this.mEnemy = aEnemy;
    }

    public double getAlpha(double d) {
        boolean bl = Angle.signRot(this.mAlpha - d) > 0.0;
        double d2 = this.mAlpha;
        for (int i = 0; i < 3; ++i) {
            d2 = this.nextAlpha(d2, d, bl);
        }
        return d2;
    }

    public int getDistMin2() {
        return this.mDistMin2;
    }

    public void moveTo(int n, int n2) {
        int n3 = Math.abs(n2);
        int n4 = n + 3 * n2;
        int n5 = this.mDX0 + n3 * this.mEnemy.getMoveX8() - Angle.posShotX(n4);
        int n6 = this.mDY0 + n3 * this.mEnemy.getMoveY8() - Angle.posShotY(n4);
        int n7 = Angle.vShotX(n4);
        int n8 = Angle.vShotY(n4);
        int n9 = this.mEnemy.getMoveX8() - n7;
        int n10 = this.mEnemy.getMoveY8() - n8;
        int n11 = this.mEnemy.getMoveY8() * n7 - this.mEnemy.getMoveX8() * n8;
        if (n11 == 0) {
            if (n5 * n10 == n6 * n9) {
                this.mTimeEnemy = this.mTimeShot = -(n5 * n10 + n6 * n9) / n9 / n10 / 2;
            } else {
                this.mTimeShot = Short.MAX_VALUE;
                this.mTimeEnemy = Short.MAX_VALUE;
            }
            this.mTimeWait = 0;
        } else {
            this.mTimeEnemy = (n5 * n8 - n6 * n7) / n11;
            this.mTimeShot = (n5 * this.mEnemy.getMoveY8() - n6 * this.mEnemy.getMoveX8()) / n11;
            this.mTimeWait = this.mTimeShot - this.mTimeEnemy;
        }
        int n12 = n9 * n9 + n10 * n10;
        int n13 = n5 * n9 + n6 * n10;
        this.mTimeMin2 = n13 > 0 ? Short.MAX_VALUE : -n13 / n12;
        int n14 = n6 * n9 - n5 * n10;
        this.mDistMin2 = n14 * n14 / n12;
    }

    double nextAlpha(double d, double d2, boolean bl) {
        int n = Angle.getAngle(d);
        double d3 = d - d2;
        if (bl) {
            if (d3 < -1.5707963267948966) {
                d3 += Math.PI * 2;
            }
        } else if (d3 > 1.5707963267948966) {
            d3 -= Math.PI * 2;
        }
        double d4 = Angle.toAngle(d3) / 3.0;
        double d5 = Math.abs(d4);
        double d6 = (double)this.mDX0 + d5 * (double)this.mEnemy.getMoveX8() - (double)Angle.posShotX(n);
        double d7 = (double)this.mDY0 + d5 * (double)this.mEnemy.getMoveY8() - (double)Angle.posShotY(n);
        double d8 = Angle.vShot(n);
        double d9 = Math.atan2(d7, d6);
        double d10 = this.mEnemy.getBetha() - d9;
        double d11 = Math.asin(this.mEnemy.getVelocity8() * Math.sin(d10) / d8);
        if (d11 > 1.5707963267948966) {
            d11 = Math.PI - d11;
        } else if (d11 < -1.5707963267948966) {
            d11 = -Math.PI - d11;
        }
        return d11 + d9;
    }

    int getStep(double d, double d2) {
        double d3 = Angle.toAngle(Angle.signRot(d - d2)) / 3.0;
        d3 = this.mLeft ? Math.ceil(d3) : Math.floor(d3);
        return (int)d3;
    }

    public int getTimeEnemy() {
        return this.mTimeEnemy;
    }

    public int getTimeMin2() {
        return this.mTimeMin2;
    }

    public int getTimeShot() {
        return this.mTimeShot;
    }

    public int getTimeWait() {
        return this.mTimeWait;
    }

    public void setTo(Ship ship, int n, int n2, int n3) {
        this.mDX0 = Operation.normX8(this.mEnemy.getX8(n)) - ship.getX8() + n2;
        this.mDY0 = Operation.normY8(this.mEnemy.getY8(n)) - ship.getY8() + n3;
        this.mAlpha = Math.atan2(this.mDY0, this.mDX0);
        this.mLeft = this.mDX0 * this.mEnemy.getMoveY8() > this.mDY0 * this.mEnemy.getMoveX8();
    }
}

