/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy.measure;

import asteroid.model.ACompute;
import asteroid.model.AEnemy;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.ICompare;
import asteroid.model.Ufo;
import asteroid.strategy.measure.SimpleCompare;

public class Rating
extends ACompute {
    private ICompare mCompare;
    private int[] mPivot = new int[28];
    private AEnemy[] mTargets = new AEnemy[28];
    private int mVisibles;

    public Rating() {
        this.mCompare = new SimpleCompare();
    }

    public Rating(ICompare iCompare) {
        this.mCompare = iCompare;
    }

    public int getActives() {
        return this.mVisibles;
    }

    public void change(AEnemy aEnemy) {
        AEnemy aEnemy2;
        if (aEnemy.isVisible()) {
            ++this.mVisibles;
        }
        int n = this.mPivot[aEnemy.getID()];
        while (n > 0) {
            aEnemy2 = this.mTargets[n - 1];
            if (this.mCompare.compare(aEnemy2, aEnemy) > 0.0) {
                this.setEnemy(n--, aEnemy2);
                continue;
            }
            this.setEnemy(n, aEnemy);
            break;
        }
        if (n == 0) {
            this.setEnemy(n, aEnemy);
        }
        while (n < 27) {
            aEnemy2 = this.mTargets[n + 1];
            if (this.mCompare.compare(aEnemy, aEnemy2) > 0.0) {
                this.setEnemy(n++, aEnemy2);
                continue;
            }
            this.setEnemy(n, aEnemy);
            break;
        }
        if (n == 27) {
            this.setEnemy(n, aEnemy);
        }
    }

    private void setEnemy(int n, AEnemy aEnemy) {
        this.mTargets[n] = aEnemy;
        this.mPivot[aEnemy.getID()] = n;
    }

    public AEnemy getFirst() {
        return this.mTargets[0];
    }

    public void forAsteroid(Asteroid asteroid) {
        this.setEnemy(asteroid.getID(), asteroid);
    }

    public void forUfo(Ufo ufo) {
        this.setEnemy(ufo.getID(), ufo);
    }

    public AEnemy get(int n) {
        return this.mTargets[n];
    }

    public void init(GameModel gameModel) {
        gameModel.forAllAsteroids(this);
        gameModel.forUfo(this);
    }

    public void reset() {
        this.mVisibles = 0;
    }

    public AEnemy getSecond() {
        return this.mTargets[1];
    }
}

