/*
 * Decompiled with CFR 0.152.
 */
package asteroid.udp;

import asteroid.SimpleLogging;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class AReceiveFiFo {
    private static final int BASE = 8;
    private static final int MAX = 32;
    protected ByteBuffer[] mBuff;
    protected int mLatenz;
    protected int mWrite;
    private int mLastFrame = -1;

    AReceiveFiFo(int n) {
        this.mLatenz = n;
        this.mBuff = new ByteBuffer[8 + n + 1];
        AReceiveFiFo.init(this.mBuff, 0, 8 + n + 1);
    }

    boolean frameOrder() {
        int n = this.mBuff[this.mWrite].get(1024) & 0xFF;
        if (this.mLastFrame >= 0 && AReceiveFiFo.sign(n - this.mLastFrame) < 0) {
            SimpleLogging.addLog("frame order wrong");
            return false;
        }
        this.mLastFrame = n;
        return true;
    }

    private static void init(ByteBuffer[] byteBufferArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1026);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBufferArray[n + i] = byteBuffer;
        }
    }

    void moveRead() {
        ByteBuffer byteBuffer = this.mBuff[0];
        System.arraycopy(this.mBuff, 1, this.mBuff, 0, this.mBuff.length - 1);
        this.mBuff[this.mBuff.length - 1] = byteBuffer;
        --this.mWrite;
    }

    void moveWrite() {
        ++this.mWrite;
        if (this.mWrite == this.mBuff.length - 1) {
            if (this.mBuff.length < 32) {
                ByteBuffer[] byteBufferArray = new ByteBuffer[this.mBuff.length + 8];
                System.arraycopy(this.mBuff, 0, byteBufferArray, 0, this.mWrite);
                AReceiveFiFo.init(byteBufferArray, this.mWrite, 8);
                byteBufferArray[byteBufferArray.length - 1] = this.mBuff[this.mBuff.length - 1];
                this.mBuff = byteBufferArray;
                SimpleLogging.addLog("resize receive fifo");
            } else {
                this.moveRead();
                SimpleLogging.addLog("skip receive fifo");
            }
        }
    }

    public abstract ByteBuffer nextRead(boolean var1);

    public abstract ByteBuffer nextWrite();

    public abstract void received();

    private static int sign(int n) {
        return (n + 128 & 0xFF) - 128;
    }
}

