/*
 * Decompiled with CFR 0.152.
 */
package asteroid.udp;

import asteroid.Operation;
import asteroid.SimpleLogging;
import asteroid.udp.AHandler;
import asteroid.udp.ReceiveFiFo;
import asteroid.udp.SendFiFo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;

public class NetHandler
extends AHandler {
    public static final int PORT = 1979;
    public static final int NAME_SIZE = 38;
    private DatagramChannel mChannel;
    private boolean mFirst;
    private int mFrame;
    private int mHeiseBusy;
    private ReceiveFiFo mReceives;
    private Selector mSelector;
    private ByteBuffer mSendKey = ByteBuffer.allocateDirect(8);
    private ByteBuffer mSendName = ByteBuffer.allocateDirect(38);
    private SendFiFo mSends = new SendFiFo();

    public NetHandler(InetAddress inetAddress, int n) throws IOException {
        super("NetHandler");
        this.mReceives = new ReceiveFiFo(n);
        this.mSendKey.put("ctmame".getBytes());
        this.mSendName.put("ctname".getBytes());
        this.mSendName.put("eraser".getBytes());
        this.mChannel = DatagramChannel.open();
        this.mChannel.connect(new InetSocketAddress(inetAddress, 1979));
        this.mChannel.configureBlocking(false);
        this.mSelector = Selector.open();
        this.mChannel.register(this.mSelector, 1);
    }

    public void addKey(int n) {
        if (this.mHeiseBusy == 0) {
            this.mSends.nextWrite(n);
            try {
                this.send();
            }
            catch (IOException iOException) {
                SimpleLogging.addException(iOException);
                this.setOpen(false);
            }
        }
    }

    private void check(ByteBuffer byteBuffer) {
        if (this.mHeiseBusy > 0) {
            return;
        }
        if (this.mFirst) {
            this.mFrame = this.mFrame + 1 & 0xFF;
            int n = byteBuffer.get(1024) & 0xFF;
            if (this.mFrame != n) {
                SimpleLogging.addLog("lost frame");
                this.mFrame = n;
            }
        } else {
            this.mFrame = byteBuffer.get(1024) & 0xFF;
            this.mFirst = true;
        }
    }

    public void close() {
        if (this.mSelector != null) {
            try {
                this.mSelector.close();
            }
            catch (IOException iOException) {
                System.err.println("exception: " + iOException.getMessage());
            }
        }
        if (this.mChannel != null) {
            try {
                this.mChannel.close();
            }
            catch (IOException iOException) {
                System.err.println("exception: " + iOException.getMessage());
            }
        }
    }

    public ByteBuffer getNext(boolean bl) {
        return this.mReceives.nextRead(bl);
    }

    private void receive(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.clear();
        int n = this.mChannel.read(byteBuffer);
        if (n == 1026) {
            this.mReceives.received();
            this.mSaver.writeData(byteBuffer);
            this.mSaver.writeKey(0);
        } else if (n > 2) {
            String string = Operation.getText(byteBuffer, 0, n - 2);
            if (string.startsWith("busy")) {
                if (this.mHeiseBusy == 0) {
                    this.mHeiseBusy = 50;
                    SimpleLogging.addLog("heise.de " + string);
                }
            } else if (string.startsWith("game over")) {
                this.mHeiseBusy = 0;
                SimpleLogging.addLog("heise.de " + string);
            } else {
                this.mHeiseBusy = 0;
                SimpleLogging.addLog("illegal heise command " + n);
            }
            this.mReceives.eventRead();
        } else {
            SimpleLogging.addLog("illegal packet size " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.mTime = System.currentTimeMillis();
        try {
            this.sendKey(0);
            while (!NetHandler.interrupted()) {
                if (this.mHeiseBusy > 0) {
                    --this.mHeiseBusy;
                    if (this.mHeiseBusy == 0) {
                        this.sendKey(0);
                    }
                    NetHandler.sleep(16L);
                }
                if (!this.isOpen()) {
                    this.mReceives.eventRead();
                    continue;
                }
                if (this.mSelector.select(100L) <= 0) continue;
                Iterator<SelectionKey> iterator = this.mSelector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    if (selectionKey.isReadable()) {
                        ByteBuffer byteBuffer = this.mReceives.nextWrite();
                        this.receive(byteBuffer);
                        this.check(byteBuffer);
                    }
                    iterator.remove();
                }
            }
        }
        catch (Exception exception) {
            SimpleLogging.addException(exception);
        }
        finally {
            this.close();
        }
    }

    private void send() throws IOException {
        int n = this.mSends.nextRead();
        if (n == -1) {
            return;
        }
        if ((n & 0xFFFF) == 65535) {
            this.mSendName.clear();
            this.mChannel.write(this.mSendName);
        } else {
            this.sendKey(n);
        }
    }

    private void sendKey(int n) throws IOException {
        this.mSendKey.clear();
        this.mSendKey.put(6, (byte)n);
        this.mSendKey.put(7, (byte)(n >> 16));
        this.mChannel.write(this.mSendKey);
    }
}

