/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.statistic.AverageInt;
import java.io.PrintStream;

public class Angle {
    private static final double SHIP_FACTOR = 10.185916357881302;
    private static final double ANGLE_FACTOR = 40.74366543152521;
    private static final double ROUTE_FACTOR = 57.29577951308232;
    private static final double RAD_FACTOR = 0.02454369260617026;
    public static final double PI_05 = 1.5707963267948966;
    public static final double PI_2 = Math.PI * 2;
    public static int sDirection;
    public static double sRadiant;
    public static int sForward;
    public static int sReceivePing;
    public static int sSendPing;
    public static int sSendKey;
    public static final int[] MIN_ANGLE;
    public static final int[] MAX_ANGLE;
    public static final int[] COS_ASTEROID;
    public static final int[] SIN_ASTEROID;
    public static final int[] VX_SHOT;
    public static final int[] VY_SHOT;
    public static final double[] V_SHOT;
    public static final int[] POSX_SHOT;
    public static final int[] POSY_SHOT;
    private int[] mAngle = new int[256];
    private int mExpected;
    private AverageInt mForward = new AverageInt(3);
    private Ship mShip;

    Angle(Ship ship) {
        this.mShip = ship;
    }

    public static int getAngle(double d) {
        return (int)Math.round(Angle.toAngle(d)) & 0xFF;
    }

    public static int getAngle(int n, int n2) {
        return Angle.getAngle(Math.atan2(n2, n));
    }

    public static int cosA(int n) {
        return COS_ASTEROID[n & 0xFF];
    }

    public static int distRot(int n) {
        return Math.abs(Angle.signRot(n));
    }

    int getFireDirection() {
        return this.mAngle[sSendPing - sForward & 0xFF] & 0xFF;
    }

    void initDirection() {
        for (int i = 0; i < 256; ++i) {
            this.mAngle[i] = sDirection;
        }
    }

    int getKey(int n) {
        if (n != 65535) {
            if ((n & 0x10) != 0) {
                int n2 = sSendPing;
                this.mAngle[n2] = this.mAngle[n2] + 3;
            }
            if ((n & 8) != 0) {
                int n3 = sSendPing;
                this.mAngle[n3] = this.mAngle[n3] - 3;
            }
        }
        sSendKey = n;
        return n | sSendPing << 16;
    }

    public static int getMaxAngle(int n) {
        return MAX_ANGLE[n & 0x3F];
    }

    private static int maxAngle(int n) {
        if (n < 16) {
            return (n << 2) + 3;
        }
        if (n < 32) {
            return n << 2;
        }
        if (n < 48) {
            return (n << 2) + 3;
        }
        return n << 2;
    }

    public static int getMinAngle(int n) {
        return MIN_ANGLE[n & 0x3F];
    }

    private static int minAngle(int n) {
        if (n > 48) {
            return (n << 2) - 3;
        }
        if (n > 32) {
            return n << 2;
        }
        if (n > 16) {
            return (n << 2) - 3;
        }
        if (n > 0) {
            return n << 2;
        }
        return -3;
    }

    public static int getMoveX(double d, int n) {
        return (int)Math.round(d * Math.cos(Angle.toRadiant(n)));
    }

    public static int getMoveY(double d, int n) {
        return (int)Math.round(d * Math.sin(Angle.toRadiant(n)));
    }

    public static int pos34(int n) {
        return n + (n >> 1);
    }

    public static int posShotX(int n) {
        return POSX_SHOT[n & 0xFF];
    }

    public static int posShotY(int n) {
        return POSY_SHOT[n & 0xFF];
    }

    void print(PrintStream printStream, int n, int n2, int n3) {
        printStream.print(GameModel.sFrame);
        printStream.print(" ");
        printStream.print(sSendPing);
        printStream.print(" ");
        printStream.print(n);
        printStream.print(" (");
        printStream.print(n2);
        printStream.print(",");
        printStream.print(n3);
        printStream.print(") >> ");
        printStream.print("[");
        printStream.print(this.mAngle[sSendPing] & 0xFF);
        printStream.print("]");
        for (int i = 1; i < 10; ++i) {
            int n4 = sSendPing - i & 0xFF;
            printStream.print(n4 == n ? "[" : " ");
            printStream.print(this.mAngle[n4] & 0xFF);
            printStream.print(n4 == n ? "]" : " ");
        }
        printStream.println();
    }

    public static int getShipIndex(int n, int n2) {
        return 0x3F & (int)Math.round(Math.atan2(n2, n) * 10.185916357881302);
    }

    public static int shotLimit(int n) {
        if (n > 111) {
            return 111;
        }
        if (n < -111) {
            return -111;
        }
        return n;
    }

    public static int signRot(int n) {
        while (n < -128) {
            n += 256;
        }
        while (n > 128) {
            n -= 256;
        }
        return n;
    }

    public static double signRot(double d) {
        while (d < -Math.PI) {
            d += Math.PI * 2;
        }
        while (d > Math.PI) {
            d -= Math.PI * 2;
        }
        return d;
    }

    public static int sinA(int n) {
        return SIN_ASTEROID[n & 0xFF];
    }

    void synchronice(int n) {
        int n2;
        sReceivePing = n;
        if (n == 0) {
            this.mExpected = this.mExpected + 1 & 0xFF;
        } else {
            this.mForward.setValue(n, sSendPing - n + 1 & 0xFF);
            this.mExpected = n + 1 & 0xFF;
        }
        sForward = this.mForward.getAverage();
        if (this.mShip.isVisible()) {
            int n3;
            n2 = Angle.getShipIndex(this.mShip.getDx(), this.mShip.getDy());
            int n4 = sSendPing - sForward & 0xFF;
            int n5 = this.mAngle[n4];
            int n6 = MIN_ANGLE[n2];
            int n7 = MAX_ANGLE[n2];
            int n8 = Angle.signRot(n6 - n5);
            int n9 = Angle.signRot(n7 - n5);
            if (n8 > 0) {
                n3 = 0;
                while (n3 < 256) {
                    int n10 = n3++;
                    this.mAngle[n10] = this.mAngle[n10] + n8;
                }
            }
            if (n9 < 0) {
                n3 = 0;
                while (n3 < 256) {
                    int n11 = n3++;
                    this.mAngle[n11] = this.mAngle[n11] + n9;
                }
            }
        }
        n2 = this.mAngle[sSendPing];
        sSendPing = sSendPing + 1 & 0xFF;
        this.mAngle[Angle.sSendPing] = n2;
        sDirection = n2 & 0xFF;
        sRadiant = Angle.toRadiant(sDirection);
    }

    public static double toAngle(double d) {
        return d * 40.74366543152521;
    }

    public static double toRadiant(double d) {
        return d * 0.02454369260617026;
    }

    public static double toRoute(double d) {
        return d * 57.29577951308232;
    }

    public static double vShot(int n) {
        return V_SHOT[n & 0xFF];
    }

    public static int vShotX(int n) {
        return VX_SHOT[n & 0xFF];
    }

    public static int vShotY(int n) {
        return VY_SHOT[n & 0xFF];
    }

    static {
        int n;
        MIN_ANGLE = new int[64];
        MAX_ANGLE = new int[64];
        COS_ASTEROID = new int[256];
        SIN_ASTEROID = new int[256];
        VX_SHOT = new int[256];
        VY_SHOT = new int[256];
        V_SHOT = new double[256];
        POSX_SHOT = new int[]{152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 144, 144, 144, 144, 144, 136, 136, 136, 136, 128, 128, 128, 128, 120, 120, 120, 120, 112, 112, 112, 104, 104, 96, 96, 96, 88, 88, 80, 80, 80, 72, 72, 64, 64, 56, 56, 56, 48, 48, 40, 40, 32, 32, 24, 24, 16, 16, 8, 8, 0, 0, 0, -8, -8, -16, -16, -24, -32, -32, -40, -40, -40, -48, -48, -56, -56, -64, -64, -72, -72, -80, -80, -80, -88, -88, -96, -96, -96, -104, -104, -112, -112, -112, -120, -120, -120, -120, -128, -128, -128, -136, -136, -136, -144, -144, -144, -144, -152, -152, -152, -152, -152, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -152, -152, -152, -152, -152, -144, -144, -144, -144, -136, -136, -136, -128, -128, -128, -120, -120, -120, -120, -112, -112, -112, -104, -104, -96, -96, -96, -88, -88, -80, -80, -80, -72, -72, -64, -64, -56, -56, -48, -48, -40, -40, -40, -32, -32, -24, -16, -16, -8, -8, 0, 0, 0, 8, 8, 16, 16, 24, 24, 32, 32, 40, 40, 48, 48, 56, 56, 56, 64, 64, 72, 72, 80, 80, 80, 88, 88, 96, 96, 96, 104, 104, 112, 112, 112, 120, 120, 120, 120, 128, 128, 128, 128, 136, 136, 136, 136, 144, 144, 144, 144, 144, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152};
        POSY_SHOT = new int[]{0, 0, 0, 8, 8, 16, 16, 24, 24, 32, 32, 40, 40, 48, 48, 56, 56, 56, 64, 64, 72, 72, 80, 80, 80, 88, 88, 96, 96, 96, 104, 104, 112, 112, 112, 120, 120, 120, 120, 128, 128, 128, 128, 136, 136, 136, 136, 144, 144, 144, 144, 144, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 144, 144, 144, 144, 144, 136, 136, 136, 136, 128, 128, 128, 128, 120, 120, 120, 120, 112, 112, 112, 104, 104, 96, 96, 96, 88, 88, 80, 80, 80, 72, 72, 64, 64, 56, 56, 56, 48, 48, 40, 40, 32, 32, 24, 24, 16, 16, 8, 8, 0, 0, 0, -8, -8, -16, -16, -24, -32, -32, -40, -40, -40, -48, -48, -56, -56, -64, -64, -72, -72, -80, -80, -80, -88, -88, -96, -96, -96, -104, -104, -112, -112, -112, -120, -120, -120, -120, -128, -128, -128, -136, -136, -136, -144, -144, -144, -144, -152, -152, -152, -152, -152, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -160, -152, -152, -152, -152, -152, -144, -144, -144, -144, -136, -136, -136, -128, -128, -128, -120, -120, -120, -120, -112, -112, -112, -104, -104, -96, -96, -96, -88, -88, -80, -80, -80, -72, -72, -64, -64, -56, -56, -48, -48, -40, -40, -40, -32, -32, -24, -16, -16, -8, -8};
        for (n = 0; n < 256; ++n) {
            Angle.COS_ASTEROID[n] = (int)Math.round(127.0 * Math.cos(Angle.toRadiant(n)));
            Angle.SIN_ASTEROID[n] = (int)Math.round(127.0 * Math.sin(Angle.toRadiant(n)));
            Angle.VX_SHOT[n] = COS_ASTEROID[n] >> 1;
            Angle.VY_SHOT[n] = SIN_ASTEROID[n] >> 1;
            Angle.V_SHOT[n] = Math.sqrt(VX_SHOT[n] * VX_SHOT[n] + VY_SHOT[n] * VY_SHOT[n]);
        }
        for (n = 0; n < 64; ++n) {
            Angle.MIN_ANGLE[n] = Angle.minAngle(n);
            Angle.MAX_ANGLE[n] = Angle.maxAngle(n);
        }
    }
}

