/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.SimpleLogging;
import asteroid.model.AFlyable;
import asteroid.model.Asteroid;
import asteroid.model.FlyDetect;
import asteroid.model.GameModel;
import asteroid.model.ICompute;
import asteroid.model.Ship;
import asteroid.model.Ufo;

public class AsteroidVector {
    public static final int MAX_ASTEROIDS = 27;
    int mVanishs;
    int mObjects;
    private Asteroid[] mAsts = new Asteroid[27];
    private FlyDetect[] mDetect = new FlyDetect[28];
    private boolean mError;
    private Ship mShip;
    private int mSize;
    private Ufo mUfo;

    AsteroidVector(Ship ship, Ufo ufo) {
        this.mUfo = ufo;
        this.mShip = ship;
        for (int i = 0; i < 27; ++i) {
            this.mAsts[i] = new Asteroid(i);
            this.mDetect[i] = new FlyDetect();
        }
        this.mDetect[27] = new FlyDetect();
    }

    void addAsteroid(int n, int n2, int n3, int n4) {
        this.mDetect[this.mSize++].set8(n << 3, n2 << 3, n3, n4, false);
    }

    void addExplosion(int n, int n2, int n3, int n4) {
        this.mDetect[this.mSize++].set8(n << 3, n2 << 3, n3, n4, true);
    }

    void clearAll() {
        for (int i = 0; i < 27; ++i) {
            Asteroid asteroid = this.mAsts[i];
            asteroid.mState = 0;
            asteroid.initStep(0, 0);
        }
    }

    private void createNewAsteroid(Asteroid asteroid, FlyDetect flyDetect) {
        asteroid.mCreate = 1;
        asteroid.initStep(0, 0);
        asteroid.mType = flyDetect.mType;
        asteroid.setPos8(flyDetect.mX8, flyDetect.mY8, flyDetect.mZ);
        asteroid.mState = 1;
        asteroid.init(this.mShip);
        asteroid.initFire();
    }

    private void createNewExplosion(Asteroid asteroid, FlyDetect flyDetect) {
        if (asteroid.mX8 != flyDetect.mX8 || asteroid.mY8 != flyDetect.mY8) {
            this.mError = true;
            SimpleLogging.addLog("wrong explosion: " + asteroid.getIndex());
        }
        ++this.mVanishs;
        asteroid.mVanish = 1;
        asteroid.mType = flyDetect.mType;
        asteroid.setPos8(flyDetect.mX8, flyDetect.mY8, asteroid.mZ);
        asteroid.mState = 2;
        asteroid.mCountDown = 37;
        asteroid.correctCD();
    }

    void detect() {
        Object object;
        int n;
        if (GameModel.sFrame >= 439) {
            GameModel.sFrame += 0;
        }
        this.mVanishs = 0;
        int n2 = this.mObjects;
        int n3 = this.mUfo.detExplosion(this.mSize > 0 ? this.mDetect[0] : null);
        this.mObjects = n3 == 0 ? this.mSize : this.mSize - 1;
        int n4 = 0;
        block11: for (n = 0; n < 27; ++n) {
            Asteroid asteroid = this.mAsts[n];
            asteroid.mVanish = 0;
            switch (asteroid.getState()) {
                case 0: {
                    continue block11;
                }
                case 1: {
                    ++n4;
                    continue block11;
                }
                case 2: {
                    asteroid.mCountDown -= asteroid.getFrameDistance();
                    if (asteroid.mCountDown <= 0) {
                        asteroid.mState = asteroid.mCountDown == 0 ? 3 : 0;
                        --n2;
                        continue block11;
                    }
                    ++n4;
                    continue block11;
                }
                case 3: {
                    asteroid.mState = 0;
                }
            }
        }
        if (n2 > this.mObjects) {
            if (this.mObjects > 0) {
                SimpleLogging.addLog("missing vanish: " + n2 + " > " + this.mObjects);
            }
            while (n2 > this.mObjects) {
                n = -1;
                n4 = 37;
                for (int i = 0; i < 27; ++i) {
                    object = this.mAsts[i];
                    if (!((AFlyable)object).isExplosion() || ((Asteroid)object).mCountDown > n4) continue;
                    n = i;
                }
                if (n < 0) break;
                this.mAsts[n].mState = 0;
                --n2;
            }
            for (n = 26; n >= 0; --n) {
                Asteroid asteroid = this.mAsts[n];
                if (!asteroid.isVisible()) continue;
                asteroid.mState = 0;
                if (--n2 == this.mObjects) break;
            }
        }
        n = n2;
        int n5 = this.mObjects;
        block15: for (int i = 0; i < 27 && n5 > 0; ++i) {
            object = this.mDetect[this.mSize - n5];
            Asteroid asteroid = this.mAsts[i];
            switch (asteroid.getState()) {
                case 0: {
                    if (n >= n5) continue block15;
                    this.createNewAsteroid(asteroid, (FlyDetect)object);
                    --n5;
                    continue block15;
                }
                case 1: {
                    if (((FlyDetect)object).mExplosion) {
                        this.createNewExplosion(asteroid, (FlyDetect)object);
                    } else {
                        this.setOldAsteroid(asteroid, (FlyDetect)object);
                    }
                    --n;
                    --n5;
                    continue block15;
                }
                case 2: {
                    this.setOldExplosion(asteroid, (FlyDetect)object);
                    --n;
                    --n5;
                    continue block15;
                }
            }
        }
        if (n > 0) {
            SimpleLogging.addLog("missing old: " + n);
        }
        if (n5 > 0) {
            SimpleLogging.addLog("missing new: " + n5);
        }
    }

    boolean isError() {
        return this.mError;
    }

    void forAll(ICompute iCompute) {
        for (int i = 0; i < 27; ++i) {
            this.mAsts[i].doIt(iCompute);
        }
    }

    void forAllDetect(ICompute iCompute) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mDetect[i].doAsteroid(iCompute);
        }
    }

    Asteroid get(int n) {
        return this.mAsts[n];
    }

    private void setOldAsteroid(Asteroid asteroid, FlyDetect flyDetect) {
        if (asteroid.mType != flyDetect.mType) {
            this.mError = true;
            SimpleLogging.addLog("wrong asteroid: " + asteroid.getIndex());
        }
        asteroid.addStep8(flyDetect.mX8, flyDetect.mY8);
        asteroid.setPos8(flyDetect.mX8, flyDetect.mY8, flyDetect.mZ);
        asteroid.mState = 1;
        asteroid.init(this.mShip);
    }

    private void setOldExplosion(Asteroid asteroid, FlyDetect flyDetect) {
        if (asteroid.mX8 != flyDetect.mX8 || asteroid.mY8 != flyDetect.mY8) {
            this.mError = true;
            SimpleLogging.addLog("wrong explosion: " + asteroid.getIndex());
        }
        asteroid.mType = flyDetect.mType;
        asteroid.setPos8(flyDetect.mX8, flyDetect.mY8, flyDetect.mZ);
        asteroid.correctCD();
    }

    void prepare() {
        this.mError = false;
        this.mSize = 0;
    }

    void set(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Asteroid asteroid = this.mAsts[n];
        asteroid.set(n2, n3, n4, n5, n6, n7);
        switch (n7) {
            case 1: {
                asteroid.mType = 2291;
                break;
            }
            default: {
                asteroid.mType = 2256;
            }
        }
    }

    void testAsteroid(int n, int n2, int n3, int n4) {
        Asteroid asteroid = this.mAsts[n];
        asteroid.mType = 2291;
        asteroid.initStep(0, 0);
        asteroid.setPos8(n2 << 3, n3 << 3, n4);
        asteroid.mState = 1;
        ++this.mObjects;
    }

    void testExplosion(int n, int n2, int n3, int n4, int n5) {
        Asteroid asteroid = this.mAsts[n];
        asteroid.mType = 2256;
        asteroid.initStep(0, 0);
        asteroid.setPos8(n2 << 3, n3 << 3, n4);
        asteroid.mState = 2;
        asteroid.mCountDown = n5;
        ++this.mObjects;
    }

    public int getVanish() {
        return this.mVanishs;
    }
}

