/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.Operation;
import asteroid.SimpleLogging;
import asteroid.model.AsteroidVector;
import asteroid.model.GameModel;
import asteroid.model.HighScores;
import asteroid.model.Ship;
import asteroid.model.ShotVector;
import asteroid.model.Ufo;
import java.nio.ByteBuffer;

class Detector {
    public static final int TIME_5MIN = 300000;
    public static final int TIME_10MIN = 600000;
    public static final int FRAME_5MIN = 18000;
    public static final int FRAME_10MIN = 36000;
    public static final String USER_SIGN = "IHR ERGEBNIS IST EINES DER ZEHN BESTEN";
    public static final String GAME_START = "STARTKN0EPFE DRUECKEN";
    public static final String GAME_END = "SPIELENDE";
    public static final String PLAYER1 = "SPIELER 1";
    public static final String HIGHSCORE = "H0ECHSTERGEBNIS";
    int mFrameType = 4;
    int mHighScore;
    int mOtherScore;
    int mScore;
    int mLives;
    int mLevel;
    HighScores mHighScores = new HighScores();
    int mPlayFrame;
    int mStartFrame;
    String mSign = " ";
    private AsteroidVector mAsts;
    private boolean mOnLevel;
    private int mOverflow;
    private int mPlayerScore;
    private Ship mShip;
    private ShotVector mShots;
    private StringBuffer mText = new StringBuffer();
    private Ufo mUfo;

    Detector(Ship ship, Ufo ufo, AsteroidVector asteroidVector, ShotVector shotVector) {
        this.mShip = ship;
        this.mUfo = ufo;
        this.mAsts = asteroidVector;
        this.mShots = shotVector;
        this.reset();
    }

    void detect(int n) {
        this.mShip.detect();
        this.mAsts.detect();
        this.mUfo.detect();
        this.mShots.detect(n);
        if (this.mAsts.mObjects != 0) {
            this.mOnLevel = true;
        } else if (this.mOnLevel) {
            ++this.mLevel;
            this.mOnLevel = false;
        }
    }

    void interpret(ByteBuffer byteBuffer) {
        switch (byteBuffer.getShort(0) & 0xFFFF) {
            case 57345: {
                GameModel.sFrameID = 0;
                GameModel.sFrameOffset = GameModel.sFrame & 1;
                break;
            }
            case 57857: {
                GameModel.sFrameID = 1;
                GameModel.sFrameOffset = ~GameModel.sFrame & 1;
                break;
            }
            default: {
                SimpleLogging.addLog("illegale data packet!");
                return;
            }
        }
        this.mText.setLength(0);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        block52: for (int i = 2; i < 1024; i += 2) {
            int n4 = byteBuffer.getShort(i) & 0xFFFF;
            int n5 = byteBuffer.getShort(i + 2) & 0xFFFF;
            switch (n4 >> 12) {
                case 11: 
                case 13: 
                case 14: {
                    i = 99999;
                    continue block52;
                }
                case 12: {
                    int n6 = n4 & 0xFFF;
                    switch (n6) {
                        case 2291: 
                        case 2303: 
                        case 2317: 
                        case 2330: {
                            this.mAsts.addAsteroid(n, n2, n3, n6);
                            break;
                        }
                        case 2176: 
                        case 2198: 
                        case 2229: 
                        case 2256: {
                            this.mAsts.addExplosion(n, n2, n3, n6);
                            break;
                        }
                        case 2345: {
                            this.mUfo.addUfo(n, n2, n3);
                            break;
                        }
                        case 2669: {
                            ++this.mLives;
                            break;
                        }
                        case 2680: {
                            this.mText.append('A');
                            break;
                        }
                        case 2688: {
                            this.mText.append('B');
                            break;
                        }
                        case 2701: {
                            this.mText.append('C');
                            break;
                        }
                        case 2707: {
                            this.mText.append('D');
                            break;
                        }
                        case 2715: {
                            this.mText.append('E');
                            break;
                        }
                        case 2723: {
                            this.mText.append('F');
                            break;
                        }
                        case 2730: {
                            this.mText.append('G');
                            break;
                        }
                        case 2739: {
                            this.mText.append('H');
                            break;
                        }
                        case 2746: {
                            this.mText.append('I');
                            break;
                        }
                        case 2753: {
                            this.mText.append('J');
                            break;
                        }
                        case 2759: {
                            this.mText.append('K');
                            break;
                        }
                        case 2765: {
                            this.mText.append('L');
                            break;
                        }
                        case 2770: {
                            this.mText.append('M');
                            break;
                        }
                        case 2776: {
                            this.mText.append('N');
                            break;
                        }
                        case 2781: {
                            this.mText.append('0');
                            break;
                        }
                        case 2787: {
                            this.mText.append('P');
                            break;
                        }
                        case 2794: {
                            this.mText.append('Q');
                            break;
                        }
                        case 2803: {
                            this.mText.append('R');
                            break;
                        }
                        case 2811: {
                            this.mText.append('S');
                            break;
                        }
                        case 2818: {
                            this.mText.append('T');
                            break;
                        }
                        case 2824: {
                            this.mText.append('U');
                            break;
                        }
                        case 2830: {
                            this.mText.append('V');
                            break;
                        }
                        case 2835: {
                            this.mText.append('W');
                            break;
                        }
                        case 2842: {
                            this.mText.append('X');
                            break;
                        }
                        case 2847: {
                            this.mText.append('Y');
                            break;
                        }
                        case 2854: {
                            this.mText.append('Z');
                            break;
                        }
                        case 2860: {
                            this.mText.append(' ');
                            break;
                        }
                        case 2862: {
                            this.mText.append('1');
                            break;
                        }
                        case 2866: {
                            this.mText.append('2');
                            break;
                        }
                        case 2874: {
                            this.mText.append('3');
                            break;
                        }
                        case 2881: {
                            this.mText.append('4');
                            break;
                        }
                        case 2888: {
                            this.mText.append('5');
                            break;
                        }
                        case 2895: {
                            this.mText.append('6');
                            break;
                        }
                        case 2902: {
                            this.mText.append('7');
                            break;
                        }
                        case 2907: {
                            this.mText.append('8');
                            break;
                        }
                        case 2915: {
                            this.mText.append('9');
                        }
                    }
                    continue block52;
                }
                case 10: {
                    this.interpretText(this.mText, n, n2);
                    n2 = n4 & 0x3FF;
                    n = n5 & 0x3FF;
                    n3 = n5 >> 12;
                    i += 2;
                    continue block52;
                }
                case 15: {
                    int n7 = (n4 >> 2 & 2) + (n4 >> 11 & 1) + 2;
                    this.interpretShip(n7, n, n2, n4 & 0x700, n4 << 8 & 0x700, n4 >> 4 & 0xF);
                    continue block52;
                }
                default: {
                    this.interpretShip(n4 >> 12, n, n2, n5, n4, n5 >> 12);
                    i += 2;
                }
            }
        }
        this.interpretText(this.mText, n, n2);
    }

    private void interpretShip(int n, int n2, int n3, int n4, int n5, int n6) {
        n4 = Operation.getSigned(n4);
        n5 = Operation.getSigned(n5);
        if (n4 == 0 && n5 == 0 && n6 == 15) {
            this.mShots.addShot(n2, n3, n6);
        }
        if (n == 3 && n4 != 0 && n5 != 0 && n6 == 12) {
            this.mShip.addExplosion(n2, n3);
        } else if (n == 6 && n4 != 0 && n5 != 0 && n6 == 12) {
            this.mShip.addShip(n2, n3, n4, n5);
        } else {
            this.mShip.reset();
        }
    }

    private void interpretText(StringBuffer stringBuffer, int n, int n2) {
        if (stringBuffer.length() > 0) {
            if (n == 48 && n2 == 680) {
                this.mFrameType = 7;
            } else if (n == 400 && n2 == 628) {
                this.mFrameType = 6;
            } else if (n == 400 && n2 == 728 && PLAYER1.equals(stringBuffer.toString())) {
                this.mFrameType = 3;
            } else if (n == 400 && n2 == 728 && HIGHSCORE.equals(stringBuffer.toString())) {
                this.mFrameType = 2;
                this.mHighScores.reset();
            } else if (n == 400 && n2 == 792) {
                this.mFrameType = 1;
            } else if (n == 400 && n2 == 228) {
                this.mSign = stringBuffer.toString();
            } else if (n == 480 && n2 == 876) {
                this.mHighScore = Detector.toNumber(stringBuffer.toString());
            } else if (n == 768 && n2 == 876) {
                this.mOtherScore = Detector.toNumber(stringBuffer.toString());
            } else if (n == 380) {
                this.mHighScores.addValue(n2, stringBuffer.toString());
            } else if (n == 100 && n2 == 876 && this.mFrameType == 4) {
                int n3 = Detector.toNumber(stringBuffer.toString());
                if (n3 < this.mPlayerScore) {
                    this.mOverflow += 100000;
                }
                this.mPlayerScore = n3;
                this.mScore = this.mOverflow + this.mPlayerScore;
            }
            stringBuffer.setLength(0);
        }
    }

    void setPlayTime() {
        if (this.mFrameType == 4) {
            if (this.mPlayFrame < 18000) {
                this.mPlayFrame = GameModel.sFrame - this.mStartFrame;
            }
            if (this.mPlayFrame >= 18000) {
                this.mFrameType = 5;
            }
        }
    }

    void prepare() {
        this.mAsts.prepare();
        this.mShip.prepare();
        this.mUfo.prepare();
        this.mShots.prepare();
        this.mLives = 0;
        if (this.mFrameType == 3) {
            this.mFrameType = 4;
        }
    }

    void reset() {
        this.mStartFrame = GameModel.sFrame;
        this.mScore = 0;
        this.mPlayerScore = 0;
        this.mOverflow = 0;
        this.mPlayFrame = 0;
        this.mLevel = 1;
        this.mOnLevel = false;
    }

    private static int toNumber(String string) {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

