/*
 * Decompiled with CFR 0.152.
 */
package asteroid.printer;

import asteroid.model.AFlyable;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;
import asteroid.printer.APrinter;
import java.io.PrintStream;

public class AnalyseHit
extends APrinter {
    private static final int PRINT_OBJECT = 0;
    private static final int PRINT_REMEMBER = 1;
    private static final int FIND_HITS = 2;
    private static final int FIND_ASTEROID = 3;
    private static final int USE_CHARGE = 9;
    private int mAnalyse;
    private Remember[] mLastAsts = new Remember[27];
    private Remember mLastShip = new Remember();
    private Remember[] mLastShots = new Remember[6];
    private Remember mLastUfo = new Remember();
    private GameModel mModel;
    private Remember mTestShot;

    public AnalyseHit(GameModel gameModel, String string) {
        super(string);
        this.init(gameModel);
    }

    public AnalyseHit(GameModel gameModel, PrintStream printStream) {
        super(printStream);
        this.init(gameModel);
    }

    static int getDist2(int n, int n2, int n3, int n4, int n5, int n6) {
        double d = Math.sqrt(n3 * n3 + n4 * n4);
        int n7 = n5 - n;
        int n8 = n6 - n2;
        double d2 = Math.abs(n7 * n4 - n8 * n3);
        if (d != 0.0) {
            return (int)((double)Math.round(10.0 * d2 / d) / 10.0);
        }
        return Integer.MAX_VALUE;
    }

    private void findAsteroid(Asteroid asteroid) {
        Remember remember = this.mLastAsts[asteroid.getIndex()];
        if (remember.mActive && !remember.mExplosion && asteroid.isExplosion()) {
            this.mOut.print("!");
            int n = this.mTestShot.mX << 3;
            int n2 = this.mTestShot.mY << 3;
            int n3 = remember.mX << 3;
            int n4 = remember.mY << 3;
            this.mOut.print(n3 - n);
            this.mOut.print(',');
            this.mOut.print(n4 - n2);
            int n5 = 0;
            switch (remember.mZ) {
                case 0: {
                    this.mOut.print("G:");
                    n5 = 320;
                    break;
                }
                case 15: {
                    this.mOut.print("M:");
                    n5 = 160;
                    break;
                }
                case 14: {
                    this.mOut.print("K:");
                    n5 = 80;
                }
            }
            int n6 = AnalyseHit.isHit(n, n2, this.mTestShot.mMoveX8, this.mTestShot.mMoveY8, n3, n4, remember.mMoveX8, remember.mMoveY8, n5);
            if (n6 > 0) {
                this.mOut.print('x');
                this.mOut.print(n6);
            }
            this.mOut.print('!');
            this.mOut.print('M');
            this.mOut.print(':');
            this.mOut.print(this.mTestShot.mX);
            this.mOut.print(',');
            this.mOut.print(this.mTestShot.mY);
            this.mOut.print(',');
            this.mOut.print(this.mTestShot.mMoveX8);
            this.mOut.print(',');
            this.mOut.print(this.mTestShot.mMoveY8);
            this.mOut.print(',');
            this.mOut.print('A');
            this.mOut.print(':');
            this.mOut.print(remember.mX);
            this.mOut.print(',');
            this.mOut.print(remember.mY);
            this.mOut.print(',');
            this.mOut.print(remember.mZ);
            this.mOut.print(',');
            this.mOut.print(remember.mMoveX8);
            this.mOut.print(',');
            this.mOut.print(remember.mMoveY8);
            this.mOut.print(',');
            this.mOut.print(n5);
            this.mOut.print(' ');
        }
    }

    void findHits() {
        this.mAnalyse = 2;
        this.mModel.forAllShots(this);
    }

    public void forAsteroid(Asteroid asteroid) {
        Remember remember = this.mLastAsts[asteroid.getIndex()];
        switch (this.mAnalyse) {
            case 0: {
                if (asteroid.isVisible() && !remember.mActive) {
                    this.mOut.print('+');
                    break;
                }
                if (!asteroid.isVisible() && remember.mActive) {
                    this.mOut.print('-');
                    break;
                }
                if (!asteroid.isVisible() && !remember.mActive) {
                    this.mOut.print('.');
                    break;
                }
                if (asteroid.isExplosion() && !remember.mExplosion) {
                    this.mOut.print('?');
                    break;
                }
                if (asteroid.isExplosion() && remember.mExplosion) {
                    this.mOut.print('E');
                    break;
                }
                this.mOut.print('A');
                break;
            }
            case 1: {
                if (!remember.mActive) break;
                this.mOut.print(remember.mExplosion ? "E:" : "A:");
                this.printRemeber(remember);
                break;
            }
            case 3: {
                this.findAsteroid(asteroid);
                break;
            }
            case 9: {
                this.forFlyable(remember, asteroid);
                remember.mActive = asteroid.isVisible();
                remember.mExplosion = asteroid.isExplosion();
            }
        }
    }

    private void forFlyable(Remember remember, AFlyable aFlyable) {
        remember.mX = aFlyable.getX8() >> 3;
        remember.mY = aFlyable.getY8() >> 3;
        remember.mZ = aFlyable.getZ();
        remember.mMoveX8 = aFlyable.getMoveX8();
        remember.mMoveY8 = aFlyable.getMoveY8();
    }

    public void forShip(Ship ship) {
        switch (this.mAnalyse) {
            case 0: {
                if (ship.isVisible() && !this.mLastShip.mActive) {
                    this.mOut.print('+');
                    break;
                }
                if (ship.isHidden() && this.mLastShip.mActive) {
                    this.mOut.print('-');
                    break;
                }
                if (ship.isHidden() && !this.mLastShip.mActive) {
                    this.mOut.print('.');
                    break;
                }
                this.mOut.print('S');
                break;
            }
            case 1: {
                if (!this.mLastShip.mActive) break;
                this.mOut.print("S:");
                this.printRemeber(this.mLastShip);
                break;
            }
            case 9: {
                this.forFlyable(this.mLastShip, ship);
                this.mLastShip.mActive = ship.isVisible();
            }
        }
    }

    public void forShot(Shot shot) {
        Remember remember = this.mLastShots[shot.getIndex()];
        switch (this.mAnalyse) {
            case 0: {
                if (shot.isVisible() && !remember.mActive) {
                    this.mOut.print('+');
                    break;
                }
                if (shot.isHidden() && remember.mActive) {
                    this.mOut.print('-');
                    break;
                }
                if (shot.isHidden() && !remember.mActive) {
                    this.mOut.print('.');
                    break;
                }
                this.mOut.print('M');
                break;
            }
            case 1: {
                if (!remember.mActive) break;
                this.mOut.print("M:");
                this.printRemeber(remember);
                break;
            }
            case 2: {
                if (!shot.isHidden() || !remember.mActive) break;
                this.mTestShot = remember;
                this.mOut.print(shot.getIdent());
                this.mOut.print(": ");
                this.mAnalyse = 3;
                this.mModel.forAllAsteroids(this);
                this.mAnalyse = 2;
                break;
            }
            case 9: {
                this.forFlyable(remember, shot);
                remember.mActive = shot.isVisible();
            }
        }
    }

    public void forUfo(Ufo ufo) {
        Remember remember = this.mLastUfo;
        switch (this.mAnalyse) {
            case 0: {
                if (ufo.isVisible() && !remember.mActive) {
                    this.mOut.print('+');
                    break;
                }
                if (!ufo.isHidden() && remember.mActive) {
                    this.mOut.print('-');
                    break;
                }
                if (!ufo.isHidden() && !remember.mActive) {
                    this.mOut.print('.');
                    break;
                }
                if (ufo.isExplosion() && !remember.mExplosion) {
                    this.mOut.print('?');
                    break;
                }
                if (ufo.isExplosion() && remember.mExplosion) {
                    this.mOut.print('E');
                    break;
                }
                this.mOut.print('U');
                break;
            }
            case 1: {
                if (!remember.mActive) break;
                this.mOut.print(remember.mExplosion ? "X:" : "U:");
                this.printRemeber(remember);
                break;
            }
            case 2: {
                break;
            }
            case 9: {
                this.forFlyable(remember, ufo);
                remember.mActive = ufo.isVisible();
                remember.mExplosion = ufo.isExplosion();
            }
        }
    }

    static int isHit(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = n5 - n;
        int n11 = n6 - n2;
        if (Math.abs(n10) <= n9 && Math.abs(n11) <= n9) {
            return 1;
        }
        if (Math.abs(n10 -= n3) <= n9 && Math.abs(n11 -= n4) <= n9) {
            return 2;
        }
        if (Math.abs(n10 -= n3) <= n9 && Math.abs(n11 -= n4) <= n9) {
            return 3;
        }
        n10 = n5 - n + n7;
        n11 = n6 - n2 + n8;
        if (Math.abs(n10) <= n9 && Math.abs(n11) <= n9) {
            return 4;
        }
        if (Math.abs(n10 -= n3) <= n9 && Math.abs(n11 -= n4) <= n9) {
            return 5;
        }
        if (Math.abs(n10 -= n3) <= n9 && Math.abs(n11 -= n4) <= n9) {
            return 6;
        }
        return 0;
    }

    private void init(GameModel gameModel) {
        int n;
        this.mModel = gameModel;
        for (n = 0; n < 6; ++n) {
            this.mLastShots[n] = new Remember();
        }
        for (n = 0; n < 27; ++n) {
            this.mLastAsts[n] = new Remember();
        }
    }

    void prepareNext() {
        this.mAnalyse = 9;
        this.mModel.forShip(this);
        this.mModel.forUfo(this);
        this.mModel.forAllAsteroids(this);
        this.mModel.forAllShots(this);
    }

    public void print() {
        if (this.mModel.getShip().isVisible()) {
            this.mOut.print("Frame ");
            this.mOut.print(GameModel.sFrame);
            this.mOut.print("   ");
            this.printStatus();
            this.findHits();
            this.prepareNext();
            this.mOut.println();
        }
    }

    void printLast() {
        this.mAnalyse = 1;
        this.mModel.forShip(this);
        this.mModel.forUfo(this);
        this.mModel.forAllAsteroids(this);
        this.mModel.forAllShots(this);
    }

    void printRemeber(Remember remember) {
        this.mOut.print(remember.mX);
        this.mOut.print(',');
        this.mOut.print(remember.mY);
        this.mOut.print(';');
        this.mOut.print(remember.mMoveX8);
        this.mOut.print(',');
        this.mOut.print(remember.mMoveY8);
        this.mOut.print(' ');
    }

    void printStatus() {
        this.mAnalyse = 0;
        this.mModel.forShip(this);
        this.mOut.print(' ');
        this.mModel.forUfo(this);
        this.mOut.print(' ');
        this.mModel.forAllAsteroids(this);
        this.mOut.print(' ');
        this.mModel.forAllShots(this);
        this.mOut.print("   ");
    }

    static double getRadius(int n, int n2, int n3, int n4, int n5, int n6) {
        double d = n3 * n3 + n4 * n4;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        double d2 = n7 * n3 + n8 * n4;
        if (d != 0.0) {
            return (double)Math.round(100.0 * d2 / d) / 100.0;
        }
        return 2.147483647E9;
    }

    private class Remember {
        boolean mActive;
        boolean mExplosion;
        int mMoveX8;
        int mMoveY8;
        int mX;
        int mY;
        int mZ;

        private Remember() {
        }
    }
}

