/*
 * Decompiled with CFR 0.152.
 */
package asteroid.printer;

import asteroid.model.AEnemy;
import asteroid.model.AFlyable;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Shot;
import asteroid.model.Ufo;
import asteroid.printer.APrinter;
import asteroid.printer.Remember;
import asteroid.printer.RememberModel;
import java.io.PrintStream;

public class Collision
extends APrinter {
    private int[][] mHitDist = new int[6][27];
    private int[][] mHitTime = new int[6][27];
    private RememberModel mLast = new RememberModel();
    private double[] mMaxSize = new double[4];
    private int[] mMinDist = new int[6];
    private int[] mMinObj = new int[6];
    private int[] mMinTime = new int[6];
    private GameModel mModel;
    private Shot mShot;

    public Collision(GameModel gameModel, PrintStream printStream) {
        super(printStream);
        this.mModel = gameModel;
    }

    public Collision(GameModel gameModel, String string) {
        super(string);
        this.mModel = gameModel;
    }

    void findCollision() {
        int n;
        for (n = 0; n < 6; ++n) {
            this.mMinDist[n] = Integer.MAX_VALUE;
            this.mMinTime[n] = Integer.MAX_VALUE;
            this.mMinObj[n] = -1;
        }
        for (n = 0; n < 6; ++n) {
            for (int i = 0; i < 27; ++i) {
                int n2 = this.mHitTime[n][i];
                int n3 = this.mHitDist[n][i];
                if (n3 >= this.mMinDist[n] && (n3 != this.mMinDist[n] || n2 >= this.mMinTime[n])) continue;
                this.mMinDist[n] = n3;
                this.mMinTime[n] = n2;
                this.mMinObj[n] = i;
            }
        }
        for (n = 0; n < 6; ++n) {
            this.mOut.savePos();
            this.mOut.print('M');
            this.mOut.print(n);
            this.mOut.print(':');
            if (this.mMinTime[n] < Integer.MAX_VALUE && this.mMinDist[n] < Integer.MAX_VALUE) {
                this.mOut.print(this.mMinTime[n] / 100);
                this.mOut.print(',');
                this.mOut.print(this.mMinDist[n] / 100);
                this.mOut.print(':');
                this.mOut.print('A');
                this.mOut.print(this.mMinObj[n]);
            }
            this.mOut.fill(16);
        }
        this.mOut.println();
    }

    public void forAsteroid(Asteroid asteroid) {
        this.mOut.savePos();
        if (this.mShot == null) {
            this.mOut.print(asteroid.getIdent());
            this.mOut.print(':');
            if (asteroid.isVisible()) {
                this.forFlyable(asteroid);
            }
        } else {
            this.mOut.print(':');
            if (asteroid.isVisible() && this.mShot.isVisible()) {
                this.test2(asteroid);
            } else {
                this.mHitDist[this.mShot.getIndex()][asteroid.getIndex()] = Integer.MAX_VALUE;
                this.mHitTime[this.mShot.getIndex()][asteroid.getIndex()] = Integer.MAX_VALUE;
            }
        }
        this.mOut.fill(20);
    }

    void forFlyable(AFlyable aFlyable) {
        this.mOut.print(aFlyable.getX8());
        this.mOut.print(',');
        this.mOut.print(aFlyable.getY8());
        this.mOut.print(',');
        this.mOut.print(aFlyable.getMoveX8());
        this.mOut.print(',');
        this.mOut.print(aFlyable.getMoveY8());
    }

    public void forShot(Shot shot) {
        this.mOut.savePos();
        this.mOut.print(shot.getIdent());
        this.mOut.print(':');
        if (shot.isVisible()) {
            this.forFlyable(shot);
        }
        this.mOut.fill(24);
        this.mShot = shot;
        this.mModel.forUfo(this);
        this.mModel.forAllAsteroids(this);
        this.mOut.println();
    }

    public void forUfo(Ufo ufo) {
    }

    void printMaxSize() {
        for (int i = 0; i < 4; ++i) {
            this.mOut.savePos();
            this.mOut.print(this.mMaxSize[i]);
            this.mOut.fill(20);
        }
        this.mOut.println();
    }

    public void print() {
        if (this.mModel.getShip().isVisible()) {
            this.mShot = null;
            this.mOut.savePos();
            this.mOut.fill(24);
            this.mModel.forAllAsteroids(this);
            this.mOut.println();
            this.mModel.forAllShots(this);
            this.mModel.forAllAsteroids(this.mLast);
            this.mModel.forAllShots(this.mLast);
            this.findCollision();
            this.mOut.println();
        }
    }

    void test1(AEnemy aEnemy) {
        int n = this.mShot.getMoveX8() * aEnemy.getMoveY8() - this.mShot.getMoveY8() * aEnemy.getMoveX8();
        if (n == 0) {
            this.mOut.print("parallel");
        } else {
            int n2 = aEnemy.getX8() - this.mShot.getX8();
            int n3 = aEnemy.getY8() - this.mShot.getY8();
            double d = (double)(n2 * aEnemy.getMoveY8() - n3 * aEnemy.getMoveX8()) / (double)n;
            double d2 = (double)(n2 * this.mShot.getMoveY8() - n3 * this.mShot.getMoveX8()) / (double)n;
            this.mOut.print((int)Math.round(d));
            this.mOut.print(',');
            this.mOut.print((int)Math.round(d2));
        }
    }

    void test2(Asteroid asteroid) {
        int n;
        int n2 = asteroid.getX8() - this.mShot.getX8();
        int n3 = asteroid.getY8() - this.mShot.getY8();
        int n4 = asteroid.getMoveX8() - this.mShot.getMoveX8();
        int n5 = n4 * n4 + (n = asteroid.getMoveY8() - this.mShot.getMoveY8()) * n;
        if (n5 != 0) {
            int n6 = -100 * (n2 * n4 + n3 * n) / n5;
            long l = 100 * (n2 * n - n3 * n4);
            long l2 = l * l / (long)n5;
            l2 = (long)Math.sqrt(l2);
            if (n6 > 0 && l2 < Integer.MAX_VALUE) {
                this.mHitDist[this.mShot.getIndex()][asteroid.getIndex()] = (int)l2;
                this.mHitTime[this.mShot.getIndex()][asteroid.getIndex()] = n6;
                this.mOut.print(n6 / 100);
                this.mOut.print(',');
                this.mOut.print(l2 / 100L);
                return;
            }
        }
        this.mHitDist[this.mShot.getIndex()][asteroid.getIndex()] = Integer.MAX_VALUE;
        this.mHitTime[this.mShot.getIndex()][asteroid.getIndex()] = Integer.MAX_VALUE;
    }

    void test3(Remember remember, Remember remember2) {
        int n = remember.mX8 - remember2.mX8;
        int n2 = remember.mY8 - remember2.mY8;
        int n3 = remember.mMoveX8 - remember2.mMoveX8;
        int n4 = remember.mMoveY8 - remember2.mMoveY8;
        int n5 = n3 * n3 + n4 * n4;
        if (n5 != 0) {
            int n6 = -(n * n3 + n2 * n4) / n5;
            long l = n * n4 - n2 * n3;
            long l2 = l * l / (long)n5;
            l2 = (int)Math.sqrt(l2);
            if (n6 > 0 && (double)l2 < 600.0) {
                this.mOut.print('x');
                switch (remember.mZ) {
                    case 0: {
                        if (!(this.mMaxSize[0] < (double)l2)) break;
                        this.mMaxSize[0] = l2;
                        break;
                    }
                    case 15: {
                        if (!(this.mMaxSize[1] < (double)l2)) break;
                        this.mMaxSize[1] = l2;
                        break;
                    }
                    case 14: {
                        if (!(this.mMaxSize[2] < (double)l2)) break;
                        this.mMaxSize[2] = l2;
                        break;
                    }
                    default: {
                        if (!(this.mMaxSize[3] < (double)l2)) break;
                        this.mMaxSize[3] = l2;
                    }
                }
            }
        }
    }
}

