/*
 * Decompiled with CFR 0.152.
 */
package asteroid.printer;

import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;
import asteroid.printer.APrinter;
import asteroid.printer.Detect;
import java.io.PrintStream;

public class Position
extends APrinter {
    private Detect mDetect;
    private GameModel mModel;

    public Position(GameModel gameModel, String string) {
        super(string);
        this.mModel = gameModel;
        this.mDetect = new Detect(gameModel, this);
    }

    public Position(GameModel gameModel, PrintStream printStream) {
        super(printStream);
        this.mModel = gameModel;
        this.mDetect = new Detect(gameModel, this);
    }

    public void forAsteroid(Asteroid asteroid) {
        switch (asteroid.getState()) {
            case 1: {
                this.mOut.print('A');
                break;
            }
            case 2: {
                this.mOut.print('E');
                break;
            }
            case 3: {
                this.mOut.print('_');
                break;
            }
            default: {
                this.mOut.print('.');
            }
        }
    }

    public void forShip(Ship ship) {
        switch (ship.getState()) {
            case 1: {
                this.mOut.print('S');
                break;
            }
            case 2: {
                this.mOut.print('T');
                break;
            }
            case 4: {
                this.mOut.print('J');
                break;
            }
            default: {
                this.mOut.print('.');
            }
        }
    }

    public void forShot(Shot shot) {
        switch (shot.getState()) {
            case 1: {
                this.mOut.print(shot.isShip() ? (char)'M' : 'P');
                break;
            }
            default: {
                this.mOut.print('.');
            }
        }
    }

    public void forUfo(Ufo ufo) {
        switch (ufo.getState()) {
            case 1: {
                this.mOut.print('U');
                break;
            }
            case 2: {
                this.mOut.print('X');
                break;
            }
            default: {
                this.mOut.print('.');
            }
        }
    }

    public void print() {
        this.mOut.savePos();
        this.mOut.print("Frame ");
        this.mOut.print(GameModel.sFrame);
        this.mOut.fill(12);
        this.mOut.print(this.mModel.getFireDirection());
        this.mOut.fill(5);
        this.mOut.print('|');
        this.mModel.forShip(this);
        this.mModel.forUfo(this);
        this.mOut.print('|');
        this.mModel.forAllAsteroids(this);
        this.mOut.print('|');
        this.mModel.forAllShots(this);
        this.mOut.print('|');
        this.mDetect.print();
        this.mOut.println();
    }
}

