/*
 * Decompiled with CFR 0.152.
 */
package asteroid.printer;

import asteroid.Operation;
import asteroid.model.AEnemy;
import asteroid.model.AFlyable;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;
import asteroid.printer.APrinter;
import java.io.PrintStream;

public class Printer
extends APrinter {
    private GameModel mModel;
    private Ship mShip;

    public Printer(GameModel gameModel, String string) {
        super(string);
        this.mModel = gameModel;
    }

    public Printer(GameModel gameModel, PrintStream printStream) {
        super(printStream);
        this.mModel = gameModel;
    }

    public void forAsteroid(Asteroid asteroid) {
        switch (asteroid.getState()) {
            case 1: {
                this.forEnemy(asteroid.getIdent(), asteroid);
                break;
            }
            case 2: {
                this.forEnemy("E" + asteroid.getIndex(), asteroid);
            }
        }
    }

    private void forEnemy(String string, AEnemy aEnemy) {
        this.mOut.savePos();
        this.mOut.print(string);
        this.mOut.print(':');
        this.forFlyable(aEnemy);
        this.mOut.savePos();
        this.mOut.print(" fire=");
        this.mOut.print(aEnemy.getDirection());
        this.mOut.fill(12);
        double d = aEnemy.getBetha();
        this.mOut.print(" betha=");
        this.mOut.print((double)Math.round(10000.0 * d) / 10000.0);
        this.mOut.fill(26);
        this.mOut.print(" gamma=");
        double d2 = aEnemy.getGamma();
        this.mOut.print((double)Math.round(10000.0 * d2) / 10000.0);
        this.mOut.fill(40);
        this.mOut.print(" alpha=");
        this.mOut.print((double)Math.round(10000.0 * aEnemy.getAlpha()) / 10000.0);
        this.mOut.fill(54);
        double d3 = Angle.toRadiant(aEnemy.getAlpha());
        int n = Operation.signX8(aEnemy.getX8() - this.mShip.getX8() + Angle.sForward * aEnemy.getMoveX8());
        int n2 = Operation.signY8(aEnemy.getY8() - this.mShip.getY8() + Angle.sForward * aEnemy.getMoveY8());
        double d4 = Math.sqrt(n * n + n2 * n2);
        double d5 = aEnemy.getVelocity8();
        double d6 = 64.0 * Math.cos(d3 - d2) - d5 * Math.cos(d - d2);
        double d7 = d4 / d6;
        double d8 = d7 * (d6 * Math.cos(d2) - (64.0 * Math.cos(d3) - d5 * Math.cos(d)));
        double d9 = d7 * (d6 * Math.sin(d2) - (64.0 * Math.sin(d3) - d5 * Math.sin(d)));
        this.mOut.print(" dx=");
        this.mOut.print((double)Math.round(100.0 * d8) / 100.0);
        this.mOut.fill(68);
        this.mOut.print(" dy=");
        this.mOut.print((double)Math.round(100.0 * d9) / 100.0);
        this.mOut.fill(80);
        this.mOut.println();
    }

    private void forFlyable(AFlyable aFlyable) {
        this.mOut.savePos();
        this.mOut.print('(');
        this.mOut.print(aFlyable.getX8());
        this.mOut.print(',');
        this.mOut.print(aFlyable.getY8());
        this.mOut.print(',');
        this.mOut.print(aFlyable.getZ());
        this.mOut.print(')');
        this.mOut.fill(14);
        this.mOut.print('(');
        this.mOut.print(aFlyable.getMoveX8());
        this.mOut.print(',');
        this.mOut.print(aFlyable.getMoveY8());
        this.mOut.print(')');
    }

    public void forShip(Ship ship) {
        this.mShip = ship;
        if (ship.isVisible()) {
            this.mOut.savePos();
            this.mOut.print(ship.getIdent());
            this.mOut.print(':');
            this.forFlyable(ship);
            this.mOut.print('(');
            this.mOut.print(ship.getDx());
            this.mOut.print(',');
            this.mOut.print(ship.getDy());
            this.mOut.print(')');
            this.mOut.println();
        }
    }

    public void forShot(Shot shot) {
        if (shot.isVisible()) {
            this.mOut.savePos();
            this.mOut.print(shot.getIdent());
            this.mOut.print(':');
            this.forFlyable(shot);
            this.mOut.print(shot.isShip());
            this.mOut.println();
        }
    }

    public void forUfo(Ufo ufo) {
        switch (ufo.getState()) {
            case 1: {
                this.forEnemy(ufo.getIdent(), ufo);
                break;
            }
            case 2: {
                this.forEnemy("X", ufo);
            }
        }
    }

    public void print() {
        this.mOut.println();
        this.mOut.println("Frame ");
        this.mOut.println(GameModel.sFrame);
        this.mOut.println(", Direction=");
        this.mOut.println(Angle.sDirection);
        this.mModel.forShip(this);
        this.mModel.forUfo(this);
        this.mModel.forAllAsteroids(this);
        this.mModel.forAllShots(this);
    }

    void printArray(int[] nArray) {
        this.mOut.print('[');
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                this.mOut.print(',');
            }
            if (nArray[i] >= 0) {
                this.mOut.print(' ');
            }
            this.mOut.print(nArray[i]);
        }
        this.mOut.print(']');
    }
}

