/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy;

import asteroid.model.AFlyable;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.FlyDetect;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Ufo;
import asteroid.strategy.AStrategie;

public class FollowTheFirst
extends AStrategie {
    private int mAngleFirst;
    private boolean mSearchFirst;
    private int mShipX;
    private int mShipY;

    public FollowTheFirst(GameModel gameModel) {
        super(gameModel);
    }

    public void cleanup() {
    }

    private int getFire() {
        if (GameModel.sFrame % 4 == 0) {
            return 2;
        }
        return 0;
    }

    public void forAsteroid(Asteroid asteroid) {
        if (asteroid.isVisible()) {
            this.forFlyable(asteroid);
        }
    }

    public void forAsteroid(FlyDetect flyDetect) {
    }

    private void forFlyable(AFlyable aFlyable) {
        if (this.mSearchFirst) {
            this.mAngleFirst = Angle.getAngle(aFlyable.getX8() + aFlyable.getMoveX8() + aFlyable.getMoveX8() - this.mShipX, aFlyable.getY8() + aFlyable.getMoveY8() + aFlyable.getMoveY8() - this.mShipY);
            this.mSearchFirst = false;
        }
    }

    public void forShip(Ship ship) {
        this.mShipX = ship.getX8() + ship.getMoveX8() + ship.getMoveX8();
        this.mShipY = ship.getY8() + ship.getMoveY8() + ship.getMoveY8();
    }

    public void forUfo(Ufo ufo) {
        if (ufo.isVisible()) {
            this.forFlyable(ufo);
        }
    }

    public int getKey() {
        if (this.mModel.isShipVisible()) {
            return this.getRot() | this.getFire();
        }
        return 0;
    }

    public void refresh() {
        if (this.mModel.getShip().isVisible()) {
            this.mSearchFirst = true;
            this.mModel.forShip(this);
            this.mModel.forUfo(this);
            this.mModel.forAllAsteroids(this);
        }
    }

    private int getRot() {
        int n = Angle.signRot(this.mAngleFirst - Angle.sDirection);
        if (n > 0) {
            return 16;
        }
        if (n < 0) {
            return 8;
        }
        return 0;
    }
}

