/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy;

import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.strategy.Gen;

public class Genom {
    private int mEndFrame;
    private Gen[] mPerm = new Gen[28];
    private Ship mShip;

    public Genom(GameModel gameModel) {
        this.mShip = gameModel.getShip();
        for (int i = 0; i <= 27; ++i) {
            this.mPerm[i] = new Gen(gameModel.getEnemy(i));
        }
    }

    void calculate(int n, int n2) {
        int n3 = Angle.sDirection;
        this.mEndFrame = GameModel.sFrame;
        for (int i = n; i < n2; ++i) {
            int n4 = this.primalShotFrame(i, this.mEndFrame);
            Gen gen = this.mPerm[i];
            gen.mInfo.calculate(gen.mEnemy, this.mShip, n3, this.mEndFrame, n4);
            this.mEndFrame += gen.mInfo.getRot();
            this.mEndFrame += gen.mInfo.getWait();
            n3 = gen.mInfo.getDirection();
        }
    }

    public int getEndFrame() {
        return this.mEndFrame;
    }

    void setEnemy(int n, AEnemy aEnemy) {
        this.mPerm[n].mEnemy = aEnemy;
    }

    Gen get(int n) {
        return this.mPerm[n];
    }

    void moveEnemy(int n, int n2) {
        for (int i = 0; i < n; ++i) {
            Gen gen = this.mPerm[i];
            if (gen.mEnemy.getID() != n2) continue;
            gen.mShot = null;
            System.arraycopy(this.mPerm, i + 1, this.mPerm, i, n - i);
            this.mPerm[n] = gen;
            break;
        }
    }

    void moveEnemy(int n, int n2, int n3) {
        for (int i = n3 + 1; i < n; ++i) {
            Gen gen = this.mPerm[i];
            if (gen.mEnemy.getID() != n2) continue;
            gen.mShot = null;
            System.arraycopy(this.mPerm, n3, this.mPerm, n3 + 1, i - n3);
            this.mPerm[n3] = gen;
            break;
        }
    }

    boolean next(int n, int n2) {
        int n3 = n2 - 1;
        if (n3 <= n) {
            return false;
        }
        int n4 = n3;
        do {
            int n5;
            int n6;
            if ((n6 = this.mPerm[--n4].mEnemy.getID()) >= this.mPerm[n5].mEnemy.getID()) continue;
            int n7 = n3;
            while (n6 >= this.mPerm[n7].mEnemy.getID()) {
                --n7;
            }
            this.swap(n4, n7);
            this.reverse(n5, n3);
            return true;
        } while (n4 != n);
        this.reverse(n, n3);
        return false;
    }

    int primalShotFrame(int n, int n2) {
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        for (int i = n - 1; i >= 0 && n3 < 4; --i) {
            Gen gen = this.mPerm[i];
            if (gen.mInfo.getFrameHit() <= n2) continue;
            ++n3;
            if (gen.mInfo.getFrameHit() >= n4) continue;
            n4 = gen.mInfo.getFrameHit();
        }
        return n3 < 4 ? n2 : n4;
    }

    private void reverse(int n, int n2) {
        while (n < n2) {
            this.swap(n++, n2--);
        }
    }

    private void swap(int n, int n2) {
        Gen gen = this.mPerm[n];
        this.mPerm[n] = this.mPerm[n2];
        this.mPerm[n2] = gen;
    }

    void update(int n, int n2, Genom genom) {
        for (int i = n; i < n2; ++i) {
            this.mPerm[i].mInfo.setAll(genom.mPerm[i].mInfo);
        }
    }
}

