/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.GameModel;
import asteroid.model.Magazine;
import asteroid.model.TargetInfo;
import asteroid.strategy.AStrategie;
import asteroid.strategy.measure.AMeasure;
import asteroid.strategy.measure.Count;
import asteroid.strategy.measure.FireTime;
import asteroid.strategy.measure.Intersect;
import asteroid.strategy.measure.Modify;
import asteroid.strategy.measure.Rating;
import asteroid.strategy.measure.RotTime;
import asteroid.strategy.measure.Stacker;
import asteroid.strategy.measure.UfoFirst;

public class Priority
extends AStrategie {
    private Magazine mMagazine = new Magazine();
    private PrintWriterFormat mOut;
    private Rating mRating = new Rating();
    private Stacker mStacker;

    public Priority(GameModel gameModel) {
        super(gameModel);
        this.mRating.init(gameModel);
        this.mStacker = new Stacker(this.mRating, new AMeasure[]{new RotTime(this.mModel.getShip(), 1.0), new Intersect(this.mModel.getShip(), 5.0E-4), new FireTime(0.01), new Modify(50.0), new Count(), new UfoFirst(60.0)}, this.mOut);
    }

    public void cleanup() {
        this.mMagazine.cleanup(this.mModel);
    }

    private void handleFire(AEnemy aEnemy) {
        TargetInfo targetInfo = aEnemy.getInfo();
        if (targetInfo.getRot() == 0 && targetInfo.getWait() == 0) {
            if (aEnemy.canFire() && this.mMagazine.canFire() && !this.mMagazine.addFire(aEnemy) && aEnemy.isFired()) {
                aEnemy.decFire();
            }
        } else if (aEnemy.isFired()) {
            aEnemy.decFire();
        }
    }

    public int getKey() {
        if (this.mModel.isShipVisible()) {
            return this.getRot() | this.mMagazine.getKey();
        }
        return 0;
    }

    public void refresh() {
        AEnemy aEnemy;
        this.mStacker.refresh(this.mModel);
        this.mMagazine.prepareFire();
        if (GameModel.sFrame >= 1090) {
            GameModel.sFrame += 0;
        }
        if (this.mModel.getShip().isVisible() && (aEnemy = this.mRating.getFirst()).isVisible()) {
            this.handleFire(aEnemy);
        }
    }

    private int getRot() {
        AEnemy aEnemy = this.mRating.getFirst();
        if (aEnemy.isVisible()) {
            AEnemy aEnemy2 = this.mRating.getSecond();
            if (aEnemy2.isVisible() && !aEnemy.canFire()) {
                return aEnemy2.getInfo().getRot(aEnemy2);
            }
            return aEnemy.getInfo().getRot(aEnemy);
        }
        return 0;
    }
}

