/*
 * Decompiled with CFR 0.152.
 */
package asteroid.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.border.Border;

public abstract class ABaseBox {
    public static void addBorder(JComponent jComponent, Border border) {
        if (jComponent.getBorder() != null) {
            jComponent.setBorder(BorderFactory.createCompoundBorder(border, jComponent.getBorder()));
        } else {
            jComponent.setBorder(border);
        }
    }

    public static void addColorBorder(JComponent jComponent, Color color) {
        ABaseBox.addBorder(jComponent, BorderFactory.createLineBorder(color));
    }

    public static void addEmptyBorder(JComponent jComponent, int n, int n2, int n3, int n4) {
        ABaseBox.addBorder(jComponent, BorderFactory.createEmptyBorder(n, n2, n3, n4));
    }

    public static Box createHorizontalBox(boolean bl) {
        return new FixBox(0, bl);
    }

    public static Box createHorizontalBox(Color color) {
        return new FixBox(0, color, false);
    }

    public static Box createHorizontalBox(boolean bl, Color color) {
        return new FixBox(0, color, bl);
    }

    public static JComponent createHorizontalGlue(Color color) {
        JComponent jComponent = (JComponent)Box.createHorizontalGlue();
        ABaseBox.addColorBorder(jComponent, color);
        return jComponent;
    }

    public static JComponent createHorizontalStrut(int n, Color color) {
        JComponent jComponent = (JComponent)Box.createHorizontalStrut(n);
        ABaseBox.addColorBorder(jComponent, color);
        return jComponent;
    }

    public static Box createVerticalBox(boolean bl) {
        return new FixBox(1, bl);
    }

    public static Box createVerticalBox(Color color) {
        return new FixBox(1, color, false);
    }

    public static Box createVerticalBox(boolean bl, Color color) {
        return new FixBox(1, color, bl);
    }

    public static JComponent createVerticalGlue(Color color) {
        JComponent jComponent = (JComponent)Box.createVerticalGlue();
        ABaseBox.addColorBorder(jComponent, color);
        return jComponent;
    }

    public static JComponent createVerticalStrut(int n, Color color) {
        JComponent jComponent = (JComponent)Box.createVerticalStrut(n);
        ABaseBox.addColorBorder(jComponent, color);
        return jComponent;
    }

    private static class FixBox
    extends Box {
        private static final long serialVersionUID = -7704265742906467223L;
        private Color mColor;
        private boolean mFixHigh;
        private boolean mFixWidth;

        public FixBox(int n, boolean bl) {
            super(n);
            if (bl) {
                if (n == 0) {
                    this.mFixHigh = true;
                } else {
                    this.mFixWidth = true;
                }
            }
        }

        public FixBox(int n, Color color, boolean bl) {
            this(n, bl);
            this.mColor = color;
        }

        public Dimension getMaximumSize() {
            if (this.mFixHigh) {
                return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
            }
            if (this.mFixWidth) {
                return new Dimension(this.getPreferredSize().width, super.getMaximumSize().height);
            }
            return super.getMaximumSize();
        }

        protected void paintComponent(Graphics graphics) {
            if (this.mColor != null) {
                graphics.setColor(this.mColor);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paintComponent(graphics);
        }
    }
}

