package asteroid.model;

import java.nio.ByteBuffer;

import asteroid.Operation;
import asteroid.SimpleLogging;
import asteroid.udp.AHandler;

class Detector {
	public static final int TIME_5MIN = 5 * 60 * 1000;
	public static final int TIME_10MIN = 10 * 60 * 1000;
	public static final int FRAME_5MIN = 5 * 60 * 60;
	public static final int FRAME_10MIN = 10 * 60 * 60;
	public static final String USER_SIGN = "IHR ERGEBNIS IST EINES DER ZEHN BESTEN";
	public static final String GAME_START = "STARTKN0EPFE DRUECKEN";
	public static final String GAME_END = "SPIELENDE";
	public static final String PLAYER1 = "SPIELER 1";
	public static final String HIGHSCORE = "H0ECHSTERGEBNIS";
	int mFrameType = GameModel.FRAME_TYPE_GAME;
	int mHighScore, mOtherScore, mScore, mLives, mLevel;
	HighScores mHighScores = new HighScores();
	int mPlayFrame, mStartFrame;
	String mSign = " ";
	private AsteroidVector mAsts;
	private boolean mOnLevel;
	private int mOverflow, mPlayerScore;
	private Ship mShip;
	private ShotVector mShots;
	private StringBuffer mText = new StringBuffer();
	private Ufo mUfo;

	Detector( Ship ship, Ufo ufo, AsteroidVector asts, ShotVector shots) {
		mShip = ship;
		mUfo = ufo;
		mAsts = asts;
		mShots = shots;
		reset();
	}

	void detect( int fireDirection) {
		mShip.detect();
		mAsts.detect();
		mUfo.detect();
		mShots.detect( fireDirection);
		if (mAsts.mObjects != 0) {
			mOnLevel = true;
		}
		else if (mOnLevel) {
			++mLevel;
			mOnLevel = false;
		}
	}

	void interpret( ByteBuffer bb) {
		switch (bb.getShort( 0) & 0xFFFF) {
			case 0xE001:
				GameModel.sFrameID = 0;
				GameModel.sFrameOffset = GameModel.sFrame & 1;
				break;
			case 0xE201:
				GameModel.sFrameID = 1;
				GameModel.sFrameOffset = ~GameModel.sFrame & 1;
				break;
			default:
				SimpleLogging.addLog( "illegale data packet!");
				return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL
		}
		mText.setLength( 0);
		int x = 0, y = 0, gsf = 0;
		for (int pc = 2; pc < AHandler.RAM_SIZE; pc += 2) {
			int w0 = bb.getShort( pc) & 0xFFFF;
			int w1 = bb.getShort( pc + 2) & 0xFFFF;
			switch (w0 >> 12) {
				case Operation.HALT:
				case Operation.RTSL:
				case Operation.JMPL:
					pc = 99999;
					break;
				case Operation.JSRL:
					int addr = w0 & 0xFFF;
					switch (addr) {
						case Operation.ASTEROID_1:
						case Operation.ASTEROID_2:
						case Operation.ASTEROID_3:
						case Operation.ASTEROID_4:
							mAsts.addAsteroid( x, y, gsf, addr);
							break;
						case Operation.EXPLOSION_0:
						case Operation.EXPLOSION_1:
						case Operation.EXPLOSION_2:
						case Operation.EXPLOSION_3:
							mAsts.addExplosion( x, y, gsf, addr);
							break;
						case Operation.UFO:
							mUfo.addUfo( x, y, gsf);
							break;
						case Operation.SHIP:
							++mLives;
							break;
						case Operation.CHAR_A:
							mText.append( 'A');
							break;
						case Operation.CHAR_B:
							mText.append( 'B');
							break;
						case Operation.CHAR_C:
							mText.append( 'C');
							break;
						case Operation.CHAR_D:
							mText.append( 'D');
							break;
						case Operation.CHAR_E:
							mText.append( 'E');
							break;
						case Operation.CHAR_F:
							mText.append( 'F');
							break;
						case Operation.CHAR_G:
							mText.append( 'G');
							break;
						case Operation.CHAR_H:
							mText.append( 'H');
							break;
						case Operation.CHAR_I:
							mText.append( 'I');
							break;
						case Operation.CHAR_J:
							mText.append( 'J');
							break;
						case Operation.CHAR_K:
							mText.append( 'K');
							break;
						case Operation.CHAR_L:
							mText.append( 'L');
							break;
						case Operation.CHAR_M:
							mText.append( 'M');
							break;
						case Operation.CHAR_N:
							mText.append( 'N');
							break;
						case Operation.CHAR_O_0:
							mText.append( '0');
							break;
						case Operation.CHAR_P:
							mText.append( 'P');
							break;
						case Operation.CHAR_Q:
							mText.append( 'Q');
							break;
						case Operation.CHAR_R:
							mText.append( 'R');
							break;
						case Operation.CHAR_S:
							mText.append( 'S');
							break;
						case Operation.CHAR_T:
							mText.append( 'T');
							break;
						case Operation.CHAR_U:
							mText.append( 'U');
							break;
						case Operation.CHAR_V:
							mText.append( 'V');
							break;
						case Operation.CHAR_W:
							mText.append( 'W');
							break;
						case Operation.CHAR_X:
							mText.append( 'X');
							break;
						case Operation.CHAR_Y:
							mText.append( 'Y');
							break;
						case Operation.CHAR_Z:
							mText.append( 'Z');
							break;
						case Operation.CHAR_SPACE:
							mText.append( ' ');
							break;
						case Operation.CHAR_1:
							mText.append( '1');
							break;
						case Operation.CHAR_2:
							mText.append( '2');
							break;
						case Operation.CHAR_3:
							mText.append( '3');
							break;
						case Operation.CHAR_4:
							mText.append( '4');
							break;
						case Operation.CHAR_5:
							mText.append( '5');
							break;
						case Operation.CHAR_6:
							mText.append( '6');
							break;
						case Operation.CHAR_7:
							mText.append( '7');
							break;
						case Operation.CHAR_8:
							mText.append( '8');
							break;
						case Operation.CHAR_9:
							mText.append( '9');
							break;
					}
					break;
				case Operation.LABS:
					interpretText( mText, x, y);
					y = w0 & 0x3FF;
					x = w1 & 0x3FF;
					gsf = w1 >> 12;
					pc += 2;
					break;
				case Operation.SVEC:
					int op = ((w0 >> 2) & 2) + ((w0 >> 11) & 1) + 2;
					interpretShip( op, x, y, w0 & 0x700, (w0 << 8) & 0x700, (w0 >> 4) & 0xF);
					break;
				default:
					interpretShip( w0 >> 12, x, y, w1, w0, w1 >> 12);
					pc += 2;
					break;
			}
		}
		interpretText( mText, x, y);
	}

	private void interpretShip( int op, int x, int y, int dx, int dy, int z) {
		dx = Operation.getSigned( dx);
		dy = Operation.getSigned( dy);
		if ((dx == 0) && (dy == 0) && (z == Operation.SOURCER_BIG)) {
			mShots.addShot( x, y, z);
		}
		if ((op == Operation.VCTR_SHIP_EXPLOSION) && (dx != 0) && (dy != 0) && (z == Operation.SHIP_HELL)) {
			mShip.addExplosion( x, y);
		}
		else if ((op == Operation.VCTR_SHIP) && (dx != 0) && (dy != 0) && (z == Operation.SHIP_HELL)) {
			mShip.addShip( x, y, dx, dy);
		}
		else {
			mShip.reset();
		}
	}

	private void interpretText( StringBuffer mText, int x, int y) {
		if (mText.length() > 0) {
			if ((x == 48) && (y == 680)) { //  && USER_SIGN.equals( text)
				mFrameType = GameModel.FRAME_TYPE_SCORE;
			}
			else if ((x == 400) && (y == 628)) { //  && GAME_END.equals( text)
				mFrameType = GameModel.FRAME_TYPE_END;
			}
			else if ((x == 400) && (y == 728) && Detector.PLAYER1.equals( mText.toString())) {
				mFrameType = GameModel.FRAME_TYPE_START;
			}
			else if ((x == 400) && (y == 728) && Detector.HIGHSCORE.equals( mText.toString())) {
				mFrameType = GameModel.FRAME_TYPE_HIGH;
				mHighScores.reset();
			}
			else if ((x == 400) && (y == 792)) { //  && GAME_START.equals( text)mHighScores
				mFrameType = GameModel.FRAME_TYPE_READY;
			}
			else if ((x == 400) && (y == 228)) {
				mSign = mText.toString();
			}
			else if ((x == 480) && (y == 876)) {
				mHighScore = toNumber( mText.toString());
			}
			else if ((x == 768) && (y == 876)) {
				mOtherScore = toNumber( mText.toString());
			}
			else if (x == 380) {
				mHighScores.addValue( y, mText.toString());
			}
			else if ((x == 100) && (y == 876) && (mFrameType == GameModel.FRAME_TYPE_GAME)) {
				int val = toNumber( mText.toString());
				if (val < mPlayerScore) {
					mOverflow += 100000;
				}
				mPlayerScore = val;
				mScore = mOverflow + mPlayerScore;
			}
			mText.setLength( 0);
		}
	}

	void setPlayTime() {
		if (mFrameType == GameModel.FRAME_TYPE_GAME) {
			if (mPlayFrame < FRAME_5MIN) {
				mPlayFrame = GameModel.sFrame - mStartFrame;
			}
			if (mPlayFrame >= FRAME_5MIN) {
				mFrameType = GameModel.FRAME_TYPE_GAME_OVER;
			}
		}
	}

	void prepare() {
		mAsts.prepare();
		mShip.prepare();
		mUfo.prepare();
		mShots.prepare();
		mLives = 0;
		if (mFrameType == GameModel.FRAME_TYPE_START) {
			mFrameType = GameModel.FRAME_TYPE_GAME;
		}
	}

	void reset() {
		mStartFrame = GameModel.sFrame;
		mPlayFrame = mOverflow = mPlayerScore = mScore = 0;
		mLevel = 1;
		mOnLevel = false;
	}

	private static int toNumber( String text) {
		try {
			return Integer.parseInt( text.trim());
		}
		catch (NumberFormatException ex) {
			return 0;
		}
	}
}
