package asteroid.model;

import asteroid.Operation;

public class Shot extends AFlyable {
	public static final int MAX_LIFE = 72;
	public static final int MAX_SHIP_SHOTS = 4;
	public static final double SHIP_SHOT_SPEED = 8;
	public static final double UFO_SHOT_SPEED = 10;
	public static final double SHIP_SHOT_SPEED8 = 8 * SHIP_SHOT_SPEED;
	public static final double UFO_SHOT_SPEED8 = 8 * UFO_SHOT_SPEED;
	public static int sLifeOffset;
	int mBirth, mIndex;
	double mHitTime;
	FlyInfo mLast;
	private String mIdent;
	private boolean mShip;

	Shot( int index) {
		mIndex = index;
		mShip = index < MAX_SHIP_SHOTS;
		mIdent = "M" + index;
		mLast = new FlyInfo();
	}

	Shot( int x8, int y8, int z, int moveX8, int moveY8) {
		super( x8, y8, z, moveX8, moveY8);
		mLast = new FlyInfo( x8, y8, z, moveX8, moveY8);
	}

	void setCreate( boolean value) {
		if (value) {
			mCreate = 1;
			mBirth = GameModel.sFrame;
		}
		else {
			mCreate = 0;
		}
	}

	public void doIt( ICompute comp) {
		comp.forShot( this);
	}

	public double getHitTime() {
		return mHitTime;
	}

	public String getIdent() {
		return mIdent;
	}

	public int getIndex() {
		return mIndex;
	}

	void init( int lastFire) {
		int dx = Angle.getMoveX( mShip ? SHIP_SHOT_SPEED : UFO_SHOT_SPEED, lastFire);
		int dy = Angle.getMoveY( mShip ? SHIP_SHOT_SPEED : UFO_SHOT_SPEED, lastFire);
		initStep( dx, dy);
	}

	public FlyInfo getLast() {
		return mLast;
	}

	public int getLife() {
		return GameModel.sFrame - mBirth + sLifeOffset;
	}

	boolean match8( int x8, int y8) {
		if ((mMoveX8 == 0) && (mMoveY8 == 0)) {
			int dx = Operation.signX8( x8 - mX8);
			int dy = Operation.signY8( y8 - mY8);
			return (Math.abs( dx) <= 136) && (Math.abs( dy) <= 136); // (17 * 8)
		}
		int frameDiv = getFrameDistance();
		if (frameDiv <= 0) {
			return false;
		}
		int move = (mMoveX8 * mMoveX8) + (mMoveY8 * mMoveY8);
		int dx = Operation.signX8( x8 - mX8 - (mMoveX8 * frameDiv));
		int dy = Operation.signY8( y8 - mY8 - (mMoveY8 * frameDiv));
		int dr = (dx * dx) + (dy * dy);
		return dr < move;
	}

	public boolean isShip() {
		return mShip;
	}

	public int size() {
		return 32;
	}

	public int sizeX() {
		return size();
	}

	public int sizeY() {
		return size();
	}

	void setVanish( boolean value) {
		if (value) {
			mVanish = 1;
			mLast.set( this);
			int life = getLife();
			if (life > 68) {
				Shot.sLifeOffset = (Shot.sLifeOffset - life) & 3;
			}
		}
		else {
			mVanish = 0;
		}
	}
}
