package asteroid.model;

import asteroid.Operation;
import asteroid.SimpleLogging;

public class ShotVector {
	public static final int MAX_SHOTS = 6;
	Shot[] mShots = new Shot[MAX_SHOTS];
	int mVanish;
	private FlyDetect[] mDetect = new FlyDetect[MAX_SHOTS];
	private Ship mShip;
	private int mShipShots;
	private int mSize;
	private Ufo mUfo;

	ShotVector( Ship ship, Ufo ufo) {
		mShip = ship;
		mUfo = ufo;
		for (int i = 0; i < MAX_SHOTS; ++i) {
			mShots[i] = new Shot( i);
			mDetect[i] = new FlyDetect();
		}
	}

	void addShot( int x, int y, int z) {
		mDetect[mSize++].set8( x << 3, y << 3, z, Operation.SHOT, false);
	}

	void clearAll() {
		for (int i = 0; i < MAX_SHOTS; ++i) {
			Shot shot = mShots[i];
			shot.mState = AFlyable.STATE_HIDDEN;
			shot.initStep( 0, 0);
		}
	}

	void detect( int lastFire) {
		int startShot = 0;
		for (int i = 0; i < mSize; ++i) {
			if (startShot == MAX_SHOTS) {
				SimpleLogging.addLog( "to many shots");
				break;
			}
			FlyDetect det = mDetect[i];
			Shot shot = findMatch( startShot, det);
			if (shot != null) { // alter Schuss
				shot.addStep8( det.mX8, det.mY8);
				shot.setPos8( det.mX8, det.mY8, det.mZ);
				shot.mState = AFlyable.STATE_VISIBLE;
				shot.setVanish( false);
				remove( startShot, shot.mIndex);
				startShot = shot.mIndex + 1;
				det.mIndex = shot.mIndex;
			}
			else if (mUfo.isVisible() && (i >= (mSize - 2)) && ((startShot >= Shot.MAX_SHIP_SHOTS) || (Operation.distX8( det.mX8 - mShip.mX8) > 320) || (Operation.distY8( det.mY8 - mShip.mY8) > 320))) {
//				System.out.println( "dx=" + Operation.distX8( det.mX8 - mShip.mX8) + ", dy=" + Operation.distY8( det.mY8 - mShip.mY8));
				if (startShot < Shot.MAX_SHIP_SHOTS) { // neuer Schuss Ufo
					remove( startShot, Shot.MAX_SHIP_SHOTS);
					startShot = Shot.MAX_SHIP_SHOTS;
				}
				shot = mShots[startShot];
				shot.setVanish( shot.isVisible());
				shot.setCreate( true);
				shot.initStep( 0, 0);
				shot.setPos8( det.mX8, det.mY8, det.mZ);
				shot.mState = AFlyable.STATE_VISIBLE;
				++startShot;
				det.mIndex = shot.mIndex;
			}
			else { // neuer Schuss Schiff
				shot = mShots[startShot];
				shot.setVanish( shot.isVisible());
				shot.setCreate( true);
				shot.init( lastFire);
				shot.setPos8( det.mX8, det.mY8, det.mZ);
				shot.mState = AFlyable.STATE_VISIBLE;
				++startShot;
				det.mIndex = shot.mIndex;
				if (startShot > Shot.MAX_SHIP_SHOTS) {
					SimpleLogging.addLog( "ufo shot expected");
				}
			}
		}
		remove( startShot, MAX_SHOTS);
		mShipShots = 0;
		mVanish = 0;
		for (int i = 0; i < Shot.MAX_SHIP_SHOTS; ++i) {
			Shot shot = mShots[i];
			if (shot.isVisible()) {
				++mShipShots;
			}
			if (shot.getVanish() == 1) {
				++mVanish;
			}
		}
	}

	private Shot findMatch( int start, FlyDetect det) {
		for (int i = start; i < MAX_SHOTS; ++i) {
			Shot shot = mShots[i];
			if ((shot.isVisible()) && shot.match8( det.mX8, det.mY8)) {
				return shot;
			}
		}
		return null;
	}

	void forAll( ICompute comp) {
		for (int i = 0; i < MAX_SHOTS; ++i) {
			mShots[i].doIt( comp);
		}
	}

	void forAllDetect( ICompute comp) {
		for (int i = 0; i < mSize; ++i) {
			mDetect[i].doShot( comp);
		}
	}

	Shot get( int index) {
		return mShots[index];
	}

	void prepare() {
		mSize = 0;
	}

	private void remove( int start, int end) {
		for (int i = start; i < end; ++i) {
			Shot shot = mShots[i];
			shot.setVanish( shot.isVisible());
			shot.setCreate( false);
			shot.mState = AFlyable.STATE_HIDDEN;
		}
	}

	void set( int index, int x, int y, int z) {
		Shot shot = mShots[index];
		shot.initStep( 0, 0);
		shot.setPos8( x << 3, y << 3, z);
		shot.mState = AFlyable.STATE_VISIBLE;
	}

	void set( int index, int x8, int y8, int z, int moveX8, int moveY8, int state) {
		mShots[index].set( x8, y8, z, moveX8, moveY8, state);
	}

	void set8( int index, int x8, int y8, int z) {
		Shot shot = mShots[index];
		shot.initStep( 0, 0);
		shot.setPos8( x8, y8, z);
		shot.mState = AFlyable.STATE_VISIBLE;
	}

	public int getShipShots() {
		return mShipShots;
	}

	public int getVanish() {
		return mVanish;
	}
}
