package asteroid.printer;

import java.io.PrintStream;

import asteroid.Operation;
import asteroid.model.AFlyable;
import asteroid.model.FlyDetect;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Ufo;

public class Detect extends APrinter {
	private GameModel mModel;

	public Detect( GameModel model, PrintStream ps) {
		super( ps);
		mModel = model;
	}

	public Detect( GameModel model, String file) {
		super( file);
		mModel = model;
	}

	public Detect( GameModel model, APrinter other) {
		super( other);
		mModel = model;
	}

	public void forAsteroid( FlyDetect detect) {
		switch (detect.getType()) {
			case Operation.ASTEROID_1:
				forDetect( "A1", detect);
				break;
			case Operation.ASTEROID_2:
				forDetect( "A2", detect);
				break;
			case Operation.ASTEROID_3:
				forDetect( "A3", detect);
				break;
			case Operation.ASTEROID_4:
				forDetect( "A4", detect);
				break;
			case Operation.EXPLOSION_0:
				forDetect( "E0", detect);
				break;
			case Operation.EXPLOSION_1:
				forDetect( "E1", detect);
				break;
			case Operation.EXPLOSION_2:
				forDetect( "E2", detect);
				break;
			case Operation.EXPLOSION_3:
				forDetect( "E3", detect);
				break;
		}
	}

	private void forDetect( String ident, FlyDetect detect) {
		mOut.savePos();
		mOut.print( ident);
		mOut.print( ':');
		mOut.printPos( detect.getX8());
		mOut.print( ',');
		mOut.printPos( detect.getY8());
		mOut.print( ',');
		mOut.print( detect.getZ());
		mOut.fill( 20);
	}

	private void forFlyable( String ident, AFlyable fly) {
		mOut.savePos();
		mOut.print( ident);
		mOut.print( ':');
		if (fly.isVisible() || fly.isExplosion()) {
			mOut.printPos( fly.getX8());
			mOut.print( ',');
			mOut.printPos( fly.getY8());
			mOut.print( ',');
			mOut.print( fly.getZ());
		}
		mOut.fill( 20);
	}

	public void forShip( Ship ship) {
		forFlyable( " S", ship);
	}

	public void forShot( FlyDetect detect) {
		forDetect( " M", detect);
	}

	public void forUfo( Ufo ufo) {
		forFlyable( " U", ufo);
	}

	public void print() {
		mOut.print( "    ");
		mModel.forShip( this);
		mModel.forUfo( this);
		mModel.forAllDetectAsteroids( this);
		mModel.forAllDetectShots( this);
	}
}
