package asteroid.printer;

import java.io.PrintStream;
import java.nio.ByteBuffer;

import asteroid.Operation;
import asteroid.PrintWriterFormat;
import asteroid.udp.AHandler;

public class Source {
	protected PrintWriterFormat mOut;

	public Source( PrintStream ps) {
		mOut = new PrintWriterFormat( ps);
	}

	public Source( String file) {
		mOut = new PrintWriterFormat( file);
	}

	public void print( ByteBuffer bb) {
		int shipdetect = 0;
		for (int pc = 0; pc < AHandler.RAM_SIZE; pc += 2) {
			mOut.savePos();
			int w0 = bb.getShort( pc) & 0xFFFF;
			int w1 = bb.getShort( pc + 2) & 0xFFFF;
			int op = w0 >> 12;
			printAddr( pc >> 1);
			mOut.print( ':');
			mOut.fill( 6);
			printWord( w0);
			mOut.print( " ");
			if (op <= Operation.LABS) {
				printWord( w1);
			}
			mOut.fill( 18);
			switch (op) {
				case Operation.LABS:
					int z = w1 >> 12;
					mOut.print( "LABS (");
					mOut.print( w1 & 0x3FF);
					mOut.print( ", ");
					mOut.print( w0 & 0x3FF);
					mOut.print( "), gs");
					mOut.print( z);
					printComment( "Skalierung " + ((z > 8) ? (z - 16) : z));
					break;
				case Operation.HALT:
					mOut.print( "HALT");
					pc = 99999;
					break;
				case Operation.JSRL:
					mOut.print( "JSRL CALL_");
					printCall( w0 & 0xFFF);
					break;
				case Operation.RTSL:
					mOut.print( "RTSL");
					break;
				case Operation.JMPL:
					mOut.print( "JMPL $");
					printAddr( w0);
					break;
				case Operation.SVEC:
					mOut.print( "SVEC (");
					mOut.print( Operation.getSigned( (w0 << 8) & 0x700));
					mOut.print( ", ");
					mOut.print( Operation.getSigned( w0 & 0x700));
					mOut.print( "), s");
					mOut.print( ((w0 >> 2) & 2) + ((w0 >> 11) & 1) + 2);
					mOut.print( ", z");
					mOut.print( (w0 >> 4) & 0xF);
					break;
				default:
					int dx = Operation.getSigned( w1);
					int dy = Operation.getSigned( w0);
					int dz = w1 >> 12;
					mOut.print( "VCTR (");
					mOut.print( dx);
					mOut.print( ", ");
					mOut.print( dy);
					mOut.print( "), s");
					mOut.print( op);
					mOut.print( ", z");
					mOut.print( dz);
					if ((dx == 0) && (dy == 0)) {
						if (dz == 0) {
							printComment( "Ruhezeit");
						}
						if (dz == 15) {
							printComment( "Schuss");
						}
					}
					else if (dz == Operation.SHIP_HELL) {
						++shipdetect;
						if (shipdetect == 1) {
							printComment( "Schiff");
						}
					}
					else {
						shipdetect = 0;
					}
					break;
			}
			mOut.println();
			if (op <= Operation.LABS) {
				pc += 2;
			}
		}
		mOut.println();
	}

	private void printAddr( int val) {
		printHex( val >> 8);
		printHex( val >> 4);
		printHex( val);
	}

	private void printCall( int call) {
		for (int i = 0; i < Operation.ADDRESS.length; ++i) {
			if (Operation.ADDRESS[i] == call) {
				mOut.print( Operation.NAMES[i]);
				return;
			}
		}
		mOut.print( '$');
		printAddr( call);
	}

	private void printComment( String text) {
		mOut.fill( 48);
		mOut.print( "; ");
		mOut.print( text);
	}

	private void printHex( int val) {
		val &= 0xF;
		if (val < 10) {
			mOut.print( (char) ('0' + val));
		}
		else {
			mOut.print( (char) ('A' + val - 10));
		}
	}

	private void printWord( int val) {
		printHex( val >> 12);
		printHex( val >> 8);
		printHex( val >> 4);
		printHex( val);
	}
}
