package asteroid.strategy;

import asteroid.model.AFlyable;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.FlyDetect;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Ufo;

public class FollowTheFirst extends AStrategie {
	private int mAngleFirst;
	private boolean mSearchFirst;
	private int mShipX, mShipY;

	public FollowTheFirst( GameModel model) {
		super( model);
	}

	public void cleanup() {
	}

	private int getFire() {
		if ((GameModel.sFrame % 4) == 0) {
			return KEY_FIRE;
		}
		return 0;
	}

	public void forAsteroid( Asteroid ast) {
		if (ast.isVisible()) {
			forFlyable( ast);
		}
	}

	public void forAsteroid( FlyDetect detect) {
	}

	private void forFlyable( AFlyable fly) {
		if (mSearchFirst) {
			mAngleFirst = Angle.getAngle( fly.getX8() + fly.getMoveX8() + fly.getMoveX8() - mShipX, fly.getY8() + fly.getMoveY8() + fly.getMoveY8() - mShipY);
//			mAngleFirst = 192;
			mSearchFirst = false;
		}
	}

	public void forShip( Ship ship) {
		mShipX = ship.getX8() + ship.getMoveX8() + ship.getMoveX8();
		mShipY = ship.getY8() + ship.getMoveY8() + ship.getMoveY8();
	}

	public void forUfo( Ufo ufo) {
		if (ufo.isVisible()) {
			forFlyable( ufo);
		}
	}

	public int getKey() {
		if (mModel.isShipVisible()) {
			return getRot() | getFire();
		}
		else {
			return 0;
		}
	}

	public void refresh() {
		if (mModel.getShip().isVisible()) {
			mSearchFirst = true;
			mModel.forShip( this);
			mModel.forUfo( this);
			mModel.forAllAsteroids( this);
		}
	}

	private int getRot() {
		int dif = Angle.signRot( mAngleFirst - Angle.sDirection);
		if (dif > 0) {
			return KEY_LEFT;
		}
		if (dif < 0) {
			return KEY_RIGHT;
		}
		return 0;
	}
}
