package asteroid.strategy;

import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.AsteroidVector;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Shot;

public class Genom {
	private int mEndFrame;
	private Gen[] mPerm = new Gen[AsteroidVector.MAX_ASTEROIDS + 1];
	private Ship mShip;

	public Genom( GameModel model) {
		mShip = model.getShip();
		for (int i = 0; i <= AsteroidVector.MAX_ASTEROIDS; ++i) {
			mPerm[i] = new Gen( model.getEnemy( i));
		}
	}

	void calculate( int first, int last) {
		int dir = Angle.sDirection;
		mEndFrame = GameModel.sFrame;
		for (int i = first; i < last; ++i) {
			int primalShot = primalShotFrame( i, mEndFrame);
			Gen akt = mPerm[i];
			akt.mInfo.calculate(akt.mEnemy, mShip, dir, mEndFrame, primalShot);
			mEndFrame += akt.mInfo.getRot();
			mEndFrame += akt.mInfo.getWait();
			dir = akt.mInfo.getDirection();
		}
	}

	public int getEndFrame() {
		return mEndFrame;
	}

	void setEnemy( int last, AEnemy enemy) {
		mPerm[last].mEnemy = enemy;
	}

	Gen get( int index) {
		return mPerm[index];
	}

	void moveEnemy( int last, int id) {
		for (int i = 0; i < last; ++i) {
			Gen akt = mPerm[i];
			if (akt.mEnemy.getID() == id) {
				akt.mShot = null;
				System.arraycopy( mPerm, i + 1, mPerm, i, last - i);
				mPerm[last] = akt;
				break;
			}
		}
	}

	void moveEnemy( int last, int id, int pos) {
		for (int i = pos + 1; i < last; ++i) {
			Gen akt = mPerm[i];
			if (akt.mEnemy.getID() == id) {
				akt.mShot = null;
				System.arraycopy( mPerm, pos, mPerm, pos + 1, i - pos);
				mPerm[pos] = akt;
				break;
			}
		}
	}

	boolean next( int first, int last1) {
		int last = last1 - 1;
		if (last <= first) {
			return false;
		}
		int i = last;
		for (;;) {
			int ii = i--;
			int akt = mPerm[i].mEnemy.getID();
			if (akt < mPerm[ii].mEnemy.getID()) {
				int j = last;
				while (akt >= mPerm[j].mEnemy.getID()) {
					--j;
				}
				swap( i, j);
				reverse( ii, last);
				return true;
			}
			if (i == first) {
				reverse( first, last);
				return false;
			}
		}
	}

	int primalShotFrame( int index, int refFrame) {
		int shots = 0;
		int primalFrame = Integer.MAX_VALUE;
		for (int i = index - 1; (i >= 0) && (shots < Shot.MAX_SHIP_SHOTS); --i) {
			Gen akt = mPerm[i];
			if (akt.mInfo.getFrameHit() > refFrame) {
				++shots;
				if (akt.mInfo.getFrameHit() < primalFrame) {
					primalFrame = akt.mInfo.getFrameHit();
				}
			}
		}
		return (shots < Shot.MAX_SHIP_SHOTS) ? refFrame : primalFrame;
	}

	private void reverse( int first, int last) {
		while (first < last) {
			swap( first++, last--);
		}
	}

	private void swap( int i, int j) {
		Gen temp = mPerm[i];
		mPerm[i] = mPerm[j];
		mPerm[j] = temp;
	}

	void update( int first, int last, Genom other) {
		for (int i = first; i < last; ++i) {
			mPerm[i].mInfo.setAll( other.mPerm[i].mInfo);
		}
	}
}
