package asteroid.strategy.measure;

import asteroid.Operation;
import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.Ship;

public class Precision extends AMeasure {
	private double mPrecWeight;
	private Ship mShip;

	public Precision( Ship ship, double precWeight) {
		mShip = ship;
		mPrecWeight = precWeight;
	}

	protected void measure( AEnemy enemy) {
		int dd = (enemy.getDirection() - Angle.sDirection) % 3;
		if (dd == 2) {
			dd = -1;
		}
		double dist2 = getMinDist2( enemy.getDirection() + dd, enemy);
		double size2 = enemy.sizeX() * enemy.sizeY();
		if (dist2 > size2) {
			enemy.mWeight += dist2 * mPrecWeight;
		}
	}

	private double getMinDist2( int angle, AEnemy enemy) {
		int dx = Operation.signX8( enemy.getX8() - mShip.getX8() - Angle.posShotX( angle));
		int dy = Operation.signY8( enemy.getY8() - mShip.getY8() - Angle.posShotY( angle));
		int dvx = enemy.getMoveX8() - Angle.vShotX( angle);
		int dvy = enemy.getMoveY8() - Angle.vShotY( angle);
		int v = (dvx * dvx) + (dvy * dvy);
		if (v == 0) {
			return Integer.MAX_VALUE;
		}
		double dd = (dx * dvy) - (dy * dvx);
		return dd * dd / v;
	}

	protected void print( AEnemy enemy, PrintWriterFormat out) {
	}
}
