package asteroid.strategy.measure;

import asteroid.model.ACompute;
import asteroid.model.AEnemy;
import asteroid.model.Asteroid;
import asteroid.model.AsteroidVector;
import asteroid.model.GameModel;
import asteroid.model.ICompare;
import asteroid.model.Ufo;

public class Rating extends ACompute {
	private ICompare mCompare;
	private int[] mPivot = new int[AsteroidVector.MAX_ASTEROIDS + 1];
	private AEnemy[] mTargets = new AEnemy[AsteroidVector.MAX_ASTEROIDS + 1];
	private int mVisibles;

	public Rating() {
		mCompare = new SimpleCompare();
	}

	public Rating( ICompare compare) {
		mCompare = compare;
	}

	public int getActives() {
		return mVisibles;
	}

	public void change( AEnemy akt) {
		if (akt.isVisible()) {
			++mVisibles;
		}
		int pos = mPivot[akt.getID()];
		while (pos > 0) {
			AEnemy prev = mTargets[pos - 1];
			if (mCompare.compare( prev, akt) > 0) {
				setEnemy( pos--, prev);
			}
			else {
				setEnemy( pos, akt);
				break;
			}
		}
		if (pos == 0) {
			setEnemy( pos, akt);
		}
		while (pos < AsteroidVector.MAX_ASTEROIDS) {
			AEnemy next = mTargets[pos + 1];
			if (mCompare.compare( akt, next) > 0) {
				setEnemy( pos++, next);
			}
			else {
				setEnemy( pos, akt);
				break;
			}
		}
		if (pos == AsteroidVector.MAX_ASTEROIDS) {
			setEnemy( pos, akt);
		}
	}

	private void setEnemy( int pos, AEnemy enemy) {
		mTargets[pos] = enemy;
		mPivot[enemy.getID()] = pos;
	}

	public AEnemy getFirst() {
		return mTargets[0];
	}

	public void forAsteroid( Asteroid ast) {
		setEnemy( ast.getID(), ast);
	}

	public void forUfo( Ufo ufo) {
		setEnemy( ufo.getID(), ufo);
	}

	public AEnemy get( int index) {
		return mTargets[index];
	}

	public void init( GameModel model) {
		model.forAllAsteroids( this);
		model.forUfo( this);
	}

	public void reset() {
		mVisibles = 0;
	}

	public AEnemy getSecond() {
		return mTargets[1];
	}
}
