package asteroid.strategy.measure;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.GameModel;

public class Stacker extends AMeasure {
	private AMeasure[] mMeasure;
	private PrintWriterFormat mOut;
	private Rating mStack;

	public Stacker( Rating stack, AMeasure[] measure, PrintWriterFormat out) {
		mStack = stack;
		mMeasure = measure;
		mOut = out;
	}

	protected void measure( AEnemy enemy) {
		if (enemy.isVisible()) {
			if (mOut != null) {
				mOut.savePos();
				mOut.print( enemy.getID());
				mOut.fill( 8);
			}
			enemy.mWeight = 0;
			for (int i = 0; i < mMeasure.length; ++i) {
				mMeasure[i].measure( enemy);
				if (mOut != null) {
					mMeasure[i].print( enemy, mOut);
				}
			}
			if (mOut != null) {
				mOut.println();
			}
		}
		else {
			enemy.mWeight = MAX_IGNORE;
		}
		mStack.change( enemy);
	}

	protected void print( AEnemy enemy, PrintWriterFormat out) {
	}

	public void refresh( GameModel model) {
		if (mOut != null) {
			mOut.println( GameModel.sFrame);
		}
		mStack.reset();
		model.forUfo( this);
		model.forAllAsteroids( this);
	}
}
