package asteroid.strategy.measure;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.Ufo;

public class UfoFirst extends AMeasure {
	private double mUfoWeight;

	public UfoFirst( double ufoWeight) {
		mUfoWeight = ufoWeight;
	}

	protected void measure( AEnemy enemy) {
		if (enemy.getID() == Ufo.UFO_ID) {
			enemy.mWeight -= mUfoWeight;
		}
	}

	protected void print( AEnemy enemy, PrintWriterFormat out) {
		if (enemy.getID() == Ufo.UFO_ID) {
			out.print( "ufo");
		}
		else {
			out.print( '-');
		}
		out.fill( 10);
	}
}
