package asteroid.udp;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import asteroid.SimpleLogging;

abstract class AReceiveFiFo {
	private static final int BASE = 8;
	private static final int MAX = 32;
	protected ByteBuffer[] mBuff;
	protected int mLatenz;
	protected int mWrite;
	private int mLastFrame = -1;

	AReceiveFiFo( int latenz) {
		mLatenz = latenz;
		mBuff = new ByteBuffer[BASE + latenz + 1];
		init( mBuff, 0, BASE + latenz + 1);
	}

	boolean frameOrder() {
		int frame = mBuff[mWrite].get( AHandler.FRAME_POS) & 0xFF;
		if ((mLastFrame >= 0) && (sign( frame - mLastFrame) < 0)) {
			SimpleLogging.addLog( "frame order wrong");
			return false;
		}
		mLastFrame = frame;
		return true;
	}

	private static void init( ByteBuffer[] buff, int pos, int size) {
		for (int i = 0; i < size; ++i) {
			ByteBuffer bb = ByteBuffer.allocateDirect( AHandler.FRAME_SIZE);
			bb.order( ByteOrder.LITTLE_ENDIAN);
			buff[pos + i] = bb;
		}
	}

	void moveRead() {
		ByteBuffer data = mBuff[0];
		System.arraycopy( mBuff, 1, mBuff, 0, mBuff.length - 1);
		mBuff[mBuff.length - 1] = data;
		--mWrite;
	}

	void moveWrite() {
		++mWrite;
		if (mWrite == (mBuff.length - 1)) {
			if (mBuff.length < MAX) {
				ByteBuffer[] buff = new ByteBuffer[mBuff.length + BASE];
				System.arraycopy( mBuff, 0, buff, 0, mWrite);
				init( buff, mWrite, BASE);
				buff[buff.length - 1] = mBuff[mBuff.length - 1];
				mBuff = buff;
				SimpleLogging.addLog( "resize receive fifo");
			}
			else {
				moveRead();
				SimpleLogging.addLog( "skip receive fifo");
			}
		}
	}

	public abstract ByteBuffer nextRead( boolean blocked);

	public abstract ByteBuffer nextWrite();

	public abstract void received();

	private static int sign( int val) {
		return ((val + 128) & 0xFF) - 128;
	}
}
