package asteroid.udp;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

import asteroid.Operation;
import asteroid.Player;
import asteroid.SimpleLogging;

public class FileHandler extends AHandler {
	private FileChannel mChannel;
	private int mFrame, mPing;
	private ByteBuffer mKey = ByteBuffer.allocate( 1);
	private BlockedFiFo mReceives;

	public FileHandler( String file, int testLatenz) throws IOException {
		super( "FileHandler");
		mReceives = new BlockedFiFo( testLatenz);
		FileInputStream is = new FileInputStream( file);
		mChannel = is.getChannel();
		ByteBuffer header = ByteBuffer.allocate( 0x20);
		header.order( ByteOrder.LITTLE_ENDIAN);
		header.limit( 0x19);
		if (readBuffer( header)) {
			String name = Operation.getText( header, 0, 6);
			if (AHandler.CT_MAME.equals( name)) {
				StringBuffer sb = new StringBuffer( "Client: ");
				sb.append( header.get( 13) & 0xFF);
				sb.append( '.');
				sb.append( header.get( 14) & 0xFF);
				sb.append( '.');
				sb.append( header.get( 15) & 0xFF);
				sb.append( '.');
				sb.append( header.get( 16) & 0xFF);
				sb.append( ':');
				sb.append( header.getShort( 11) & 0xFFFF);
				SimpleLogging.addLog( sb.toString());
				if (header.get( 6) == AHandler.CT_VERSION) {
					header.clear();
					if (readBuffer( header)) {
						SimpleLogging.addLog( "User: " + Operation.getText( header, 0, 0x20));
					}
				}
			}
			else {
				SimpleLogging.addLog( "Protokoll falsch");
				setOpen( false);
			}
		}
	}

	public void addKey( int key) {
		mPing = ((key >> 16) + 1) & 0xFF;
	}

	public void close() {
		try {
			mChannel.close();
		}
		catch (IOException ex) {
			System.err.println( "exception: " + ex.getMessage());
		}
	}

	public ByteBuffer getNext( boolean blocked) {
		return mReceives.nextRead( blocked);
	}

	private boolean readBuffer( ByteBuffer bb) throws IOException {
		int readed = mChannel.read( bb);
		if (readed == bb.limit()) {
			return true;
		}
		if (readed < 0) {
			SimpleLogging.addLog( "Protokoll EOF");
			setOpen( false);
		}
		else {
			SimpleLogging.addLog( "falsche Paketgroesse");
		}
		return false;
	}

	private void receive() throws IOException {
		ByteBuffer bb = mReceives.nextWrite();
		bb.rewind().limit( RAM_SIZE);
		if (readBuffer( bb)) {
			bb.clear();
			bb.put( FRAME_POS, (byte) mFrame++);
			bb.put( FRAME_PING, (byte) mPing);
			mReceives.received();
		}
	}

	public void run() {
		mTime = System.currentTimeMillis();
		try {
			while (!interrupted()) {
				if (!Player.DEBUG) {
					sleep( TIME_SLEEP);
				}
				if (isOpen()) {
					receive();
					send();
				}
			}
		}
		catch (Exception ex) {
			SimpleLogging.addException( ex);
		}
		finally {
			close();
		}
	}

	private void send() throws IOException {
		mKey.clear();
		readBuffer( mKey);
	}
}
