package asteroid.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;

import asteroid.Operation;

import junit.framework.TestCase;

public class AsteroidTest extends TestCase {
	private static final String TEST = "test\\asteroid\\model\\sample.txt";
	private Ship mShip = new Ship();
	private Ufo mUfo = new Ufo(mShip);
	private AsteroidVector mAsts = new AsteroidVector( mShip, mUfo);
	private ShotVector mShots = new ShotVector( mShip, mUfo);
	private Detector mDetector = new Detector( mShip, mUfo, mAsts, mShots);
	private BufferedReader mIS;

	public AsteroidTest( String name) {
		super( name);
	}

	protected void tearDown() throws Exception {
		mIS.close();
	}

	public void testA() {
		int lastframe = -1;
		try {
			String s = null;
			while ((s = mIS.readLine()) != null) {
				mDetector.prepare();
				StringTokenizer st = new StringTokenizer( s);
				st.nextToken(); // "Frame"
				int frame = Integer.parseInt( st.nextToken().trim()); // frameNr
				if (lastframe < 0) {
					lastframe = frame;
				}
				else {
					++lastframe;
					assertEquals( lastframe, frame);
				}
				st.nextToken(); // "AAAA....."
				while (st.hasMoreTokens()) {
					String detect = st.nextToken();
					StringTokenizer dd = new StringTokenizer( detect, ":,");
					String type = dd.nextToken();
					int x = Integer.parseInt( dd.nextToken().trim());
					int y = Integer.parseInt( dd.nextToken().trim());
					int z = Integer.parseInt( dd.nextToken().trim());
					if ("U".equals( type)) {
						mUfo.addUfo( x, y, z);
					}
					else if ("X".equals( type)) {
					}
					else if ("A1".equals( type)) {
						mAsts.addAsteroid( y, z, x, Operation.ASTEROID_1);
					}
					else if ("A2".equals( type)) {
						mAsts.addAsteroid( y, z, x, Operation.ASTEROID_2);
					}
					else if ("A3".equals( type)) {
						mAsts.addAsteroid( y, z, x, Operation.ASTEROID_3);
					}
					else if ("A4".equals( type)) {
						mAsts.addAsteroid( y, z, x, Operation.ASTEROID_4);
					}
					else if ("E0".equals( type)) {
						mAsts.addExplosion( y, z, x, Operation.EXPLOSION_0);
					}
					else if ("E1".equals( type)) {
						mAsts.addExplosion( y, z, x, Operation.EXPLOSION_1);
					}
					else if ("E2".equals( type)) {
						mAsts.addExplosion( y, z, x, Operation.EXPLOSION_2);
					}
					else if ("E3".equals( type)) {
						mAsts.addExplosion( y, z, x, Operation.EXPLOSION_3);
					}
				}
				mDetector.detect( 0);
				assertFalse( mAsts.isError());
			}
		}
		catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	protected void setUp() throws Exception {
		File f = new File( TEST);
		mIS = new BufferedReader( new FileReader( f.getAbsoluteFile()));
		mAsts.clearAll();
		mUfo.mState = AFlyable.STATE_HIDDEN;
	}
}
