package asteroid.model;

import asteroid.Operation;

import junit.framework.TestCase;

public class AsteroidVectorTest extends TestCase {
	private Ship mShip = new Ship();
	private Ufo mUfo = new Ufo( mShip);
	private AsteroidVector mAsts = new AsteroidVector( mShip, mUfo);

	public AsteroidVectorTest( String name) {
		super( name);
	}

	private void checkAst( int index, int x, int y, int state) {
		Asteroid ast = mAsts.get( index);
		assertNotNull( ast);
		assertEquals( state, ast.mState);
		if (ast.isVisible() || ast.isExplosion()) {
			assertEquals( x << 3, ast.mX8);
			assertEquals( y << 3, ast.mY8);
		}
	}

	// ABC......
	// DEF......
	public void testA0() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testAsteroid( 1, 2000, 2000, 1);
		mAsts.testAsteroid( 2, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 2100, 2100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 2100, 2100, AFlyable.STATE_VISIBLE);
		checkAst( 2, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// AB..C....
	// DE..F....
	public void testA1() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testAsteroid( 1, 2000, 2000, 1);
		mAsts.testAsteroid( 4, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 2100, 2100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 2100, 2100, AFlyable.STATE_VISIBLE);
		checkAst( 2, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 3, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 4, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// A..B..C..
	// D..E..F..
	public void testA2() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testAsteroid( 3, 2000, 2000, 1);
		mAsts.testAsteroid( 6, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 2100, 2100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 3, 2100, 2100, AFlyable.STATE_VISIBLE);
		checkAst( 4, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 5, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 6, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// ..ABC....
	// ..DEF....
	public void testA3() {
		mAsts.testAsteroid( 2, 1000, 1000, 1);
		mAsts.testAsteroid( 3, 2000, 2000, 1);
		mAsts.testAsteroid( 4, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 2100, 2100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 3, 2100, 2100, AFlyable.STATE_VISIBLE);
		checkAst( 4, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// AAA......
	// DDD......
	public void testA4() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testAsteroid( 1, 1000, 1000, 1);
		mAsts.testAsteroid( 2, 1000, 1000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 2, 1100, 1100, AFlyable.STATE_VISIBLE);
	}

	// A..AA....
	// D..DD....
	public void testA5() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testAsteroid( 3, 1000, 1000, 1);
		mAsts.testAsteroid( 4, 1000, 1000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 3, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 4, 1100, 1100, AFlyable.STATE_VISIBLE);
	}

	// ABC......
	// DEFG.....
	public void testA6() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testAsteroid( 1, 2000, 2000, 1);
		mAsts.testAsteroid( 2, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 2100, 2100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 4100, 4100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 2100, 2100, AFlyable.STATE_VISIBLE);
		checkAst( 2, 3100, 3100, AFlyable.STATE_VISIBLE);
		checkAst( 3, 4100, 4100, AFlyable.STATE_VISIBLE);
	}

	// AB..C....
	// DEG.F....
	public void testA7() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testAsteroid( 1, 2000, 2000, 1);
		mAsts.testAsteroid( 4, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 2100, 2100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 4100, 4100, 0, Operation.ASTEROID_1);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 2100, 2100, AFlyable.STATE_VISIBLE);
		checkAst( 2, 4100, 4100, AFlyable.STATE_VISIBLE);
		checkAst( 3, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 4, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// AbC......
	// DbF......
	public void testB0() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testExplosion( 1, 2000, 2000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 2, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addExplosion( 2000, 2000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 2000, 2000, AFlyable.STATE_EXPLOSION);
		checkAst( 2, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// AaC......
	// DaF......
	public void testB1() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testExplosion( 1, 1000, 1000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 2, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 2, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// AaA......
	// DaF......
	public void testB2() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testExplosion( 1, 1000, 1000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 2, 1000, 1000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 900, 900, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 2, 900, 900, AFlyable.STATE_VISIBLE);
	}

	// AdC......
	// DdD......
	public void testB3() {
		mAsts.testAsteroid( 0, 1100, 1100, 1);
		mAsts.testExplosion( 1, 1000, 1000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 2, 900, 900, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1000, 1000, 0, Operation.ASTEROID_1);
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 1000, 1000, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1000, 1000, AFlyable.STATE_VISIBLE);
		checkAst( 1, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 2, 1000, 1000, AFlyable.STATE_VISIBLE);
	}

	// A..bC....
	// D..bF....
	public void testC0() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testExplosion( 3, 2000, 2000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 4, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addExplosion( 2000, 2000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 3, 2000, 2000, AFlyable.STATE_EXPLOSION);
		checkAst( 4, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// A..aC....
	// D..aF....
	public void testC1() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testExplosion( 3, 1000, 1000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 4, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 3, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 4, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// A..aA....
	// D..aF....
	public void testC2() {
		mAsts.testAsteroid( 0, 1000, 1000, 1);
		mAsts.testExplosion( 3, 1000, 1000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 4, 1000, 1000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 900, 900, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 3, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 4, 900, 900, AFlyable.STATE_VISIBLE);
	}

	// A..dC....
	// D..dD....
	public void testC3() {
		mAsts.testAsteroid( 0, 1100, 1100, 1);
		mAsts.testExplosion( 3, 1000, 1000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 4, 900, 900, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1000, 1000, 0, Operation.ASTEROID_1);
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 1000, 1000, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 1000, 1000, AFlyable.STATE_VISIBLE);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 3, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 4, 1000, 1000, AFlyable.STATE_VISIBLE);
	}

	// ..AbC....
	// ..abF....
	public void testD0() {
		mAsts.testAsteroid( 2, 1000, 1000, 1);
		mAsts.testExplosion( 3, 2000, 2000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 4, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addExplosion( 2000, 2000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 3, 2000, 2000, AFlyable.STATE_EXPLOSION);
		checkAst( 4, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// ..AaC....
	// ..aaF....
	public void testD1() {
		mAsts.testAsteroid( 2, 1000, 1000, 1);
		mAsts.testExplosion( 3, 1000, 1000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 4, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 3, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 4, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// ..AaA....
	// ..aaF....
	public void testD2() {
		mAsts.testAsteroid( 2, 1000, 1000, 1);
		mAsts.testExplosion( 3, 1000, 1000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 4, 1000, 1000, 1);
		mAsts.prepare();
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 900, 900, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 3, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 4, 900, 900, AFlyable.STATE_VISIBLE);
	}

	// ..AaA....
	// ..aaa....
	public void testD3() {
		mAsts.testAsteroid( 2, 1000, 1000, 1);
		mAsts.testExplosion( 3, 1000, 1000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 4, 1000, 1000, 1);
		mAsts.prepare();
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.detect();
		checkAst( 0, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 3, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 4, 1000, 1000, AFlyable.STATE_EXPLOSION);
	}

	// ..AaA....
	// ..BaF....
	public void testD4() {
		mAsts.testAsteroid( 2, 1000, 1000, 1);
		mAsts.testExplosion( 3, 1000, 1000, 1, Asteroid.EXPLOSION_COUNTDOWN);
		mAsts.testAsteroid( 4, 1000, 1000, 1);
		mAsts.prepare();
		mAsts.addAsteroid( 1100, 1100, 0, Operation.ASTEROID_1);
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 900, 900, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 1100, 1100, AFlyable.STATE_VISIBLE);
		checkAst( 3, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 4, 900, 900, AFlyable.STATE_VISIBLE);
	}

	// ..AbC....
	// ..a.F....
	public void testE0() {
		mAsts.testAsteroid( 2, 1000, 1000, 1);
		mAsts.testExplosion( 3, 2000, 2000, 1, 0);
		mAsts.testAsteroid( 4, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 3, 0, 0, AFlyable.STATE_BLOCKED);
		checkAst( 4, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// ..AaC....
	// ..a.F....
	public void testE1() {
		mAsts.testAsteroid( 2, 1000, 1000, 1);
		mAsts.testExplosion( 3, 1000, 1000, 1, 0);
		mAsts.testAsteroid( 4, 3000, 3000, 1);
		mAsts.prepare();
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 3100, 3100, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 3, 0, 0, AFlyable.STATE_BLOCKED);
		checkAst( 4, 3100, 3100, AFlyable.STATE_VISIBLE);
	}

	// ..AaA....
	// ..a.F....
	public void testE2() {
		mAsts.testAsteroid( 2, 1000, 1000, 1);
		mAsts.testExplosion( 3, 1000, 1000, 1, 0);
		mAsts.testAsteroid( 4, 1000, 1000, 1);
		mAsts.prepare();
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addAsteroid( 900, 900, 0, Operation.ASTEROID_1);
		mAsts.detect();
		checkAst( 0, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 3, 0, 0, AFlyable.STATE_BLOCKED);
		checkAst( 4, 900, 900, AFlyable.STATE_VISIBLE);
	}

	// ..AaA....
	// ..a.a....
	public void testE3() {
		mAsts.testAsteroid( 2, 1000, 1000, 1);
		mAsts.testExplosion( 3, 1000, 1000, 1, 0);
		mAsts.testAsteroid( 4, 1000, 1000, 1);
		mAsts.prepare();
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.addExplosion( 1000, 1000, 0, Operation.EXPLOSION_0);
		mAsts.detect();
		checkAst( 0, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 1, 0, 0, AFlyable.STATE_HIDDEN);
		checkAst( 2, 1000, 1000, AFlyable.STATE_EXPLOSION);
		checkAst( 3, 0, 0, AFlyable.STATE_BLOCKED);
		checkAst( 4, 1000, 1000, AFlyable.STATE_EXPLOSION);
	}

	protected void setUp() throws Exception {
		GameModel.sFrame = 0;
		mAsts.clearAll();
		mUfo.mState = AFlyable.STATE_HIDDEN;
	}
}
