package asteroid.model;

import asteroid.Operation;

import junit.framework.TestCase;

public class FlyableTest extends TestCase {
	private Ship mShip = new Ship();

	public FlyableTest( String name) {
		super( name);
	}

	static void addPos8( Ufo ufo, int x8, int y8, int z) {
		if (ufo.isVisible()) {
			ufo.addStep8( x8, y8);
		}
		ufo.setPos8( x8, y8, z);
		ufo.mState = AFlyable.STATE_VISIBLE;
	}

	public void testA() {
		Ufo ufo = new Ufo( mShip);
		GameModel.sFrame = 0;
		addPos8( ufo, 10 << 3, 20 << 3, 14);
		assertEquals( 0, ufo.getMoveX8());
		assertEquals( 0, ufo.getMoveY8());
		assertEquals( ufo.getState(), AFlyable.STATE_VISIBLE);
		GameModel.sFrame = 1;
		addPos8( ufo, 12 << 3, 23 << 3, 14);
		assertEquals( 16, ufo.getMoveX8());
		assertEquals( 24, ufo.getMoveY8());
		assertEquals( ufo.getState(), AFlyable.STATE_VISIBLE);
		GameModel.sFrame = 2;
		addPos8( ufo, 13 << 3, 25 << 3, 14);
		assertEquals( 15, ufo.getMoveX8());
		assertEquals( 23, ufo.getMoveY8());
		assertEquals( ufo.getState(), AFlyable.STATE_VISIBLE);
		ufo.mState = AFlyable.STATE_HIDDEN;
		assertEquals( ufo.getState(), AFlyable.STATE_HIDDEN);
		addPos8( ufo, 14 << 3, 27 << 3, 14);
		assertEquals( 15, ufo.getMoveX8());
		assertEquals( 23, ufo.getMoveY8());
		assertEquals( ufo.getState(), AFlyable.STATE_VISIBLE);
		ufo.mState = AFlyable.STATE_HIDDEN;
		ufo.initStep( 0, 0);
		assertEquals( 0, ufo.getMoveX8());
		assertEquals( 0, ufo.getMoveY8());
		assertEquals( ufo.getState(), AFlyable.STATE_HIDDEN);
	}

	public void testB() {
		AFlyable fly = new Ufo( mShip);
		fly.initStep( 0, 0);
		assertEquals( 0, fly.getBetha(), 0.00001);
		fly.initStep( 100, 100);
		assertEquals( Math.PI / 4, fly.getBetha(), 0.00001);
		assertEquals( 45, Angle.toRoute( fly.getBetha()), 0.00001);
		assertEquals( 1280000, fly.getVelocity28());
		assertEquals( 141.4213562373, fly.getVelocity8() / 8.0, 0.00001);
		fly.initStep( 100, -100);
		assertEquals( -Math.PI / 4, fly.getBetha(), 0.00001);
		assertEquals( -45, Angle.toRoute( fly.getBetha()), 0.00001);
		assertEquals( 1280000, fly.getVelocity28());
		assertEquals( 141.4213562373, fly.getVelocity8() / 8.0, 0.00001);
		fly.initStep( -100, 100);
		assertEquals( 3 * Math.PI / 4, fly.getBetha(), 0.00001);
		assertEquals( 135, Angle.toRoute( fly.getBetha()), 0.00001);
		assertEquals( 1280000, fly.getVelocity28());
		assertEquals( 141.4213562373, fly.getVelocity8() / 8.0, 0.00001);
		fly.initStep( -100, -100);
		assertEquals( -3 * Math.PI / 4, fly.getBetha(), 0.00001);
		assertEquals( -135, Angle.toRoute( fly.getBetha()), 0.00001);
		assertEquals( 1280000, fly.getVelocity28());
		assertEquals( 141.4213562373, fly.getVelocity8() / 8.0, 0.00001);
	}

	public void testC() {
		int size = 20;
		int x0 = 1000;
		int y0 = 1000;
		int expMoveX = 32;
		int expMoveY = 54;
		int[] testX = new int[size];
		int[] testY = new int[size];
		int x = x0 << 3;
		int y = y0 << 3;
		for (int i = 0; i < size; ++i) {
			testX[i] = (x + (i * expMoveX)) >> 3;
			testY[i] = (y + (i * expMoveY)) >> 3;
		}
		int sFrame = 5;
		int mX8 = 0;
		int mY8 = 0;
		int mMoveX8 = 0;
		int mMoveY8 = 0;
		int[] mStepX = new int[AFlyable.STEP_SIZE];
		int[] mStepY = new int[AFlyable.STEP_SIZE];
		for (int i = 0; i < size; ++i) {
			int index = sFrame & 7;
			System.out.print( index + ": testX8=" + testX[i] + ", testY8=" + testY[i]);
			int expX = (x0 << 3) + (i * expMoveX);
			int expY = (y0 << 3) + (i * expMoveY);
			System.out.print( ", expX=" + expX + ", expY=" + expY);
			int x8 = testX[i] << 3;
			int y8 = testY[i] << 3;
			if (i == 0) { // init
//				mMoveX8 = expMoveX;
//				mMoveY8 = expMoveY;
//				for (int j = 0; j < AFlyable.STEP_SIZE; ++j) {
////					mStepX[(index + j) & 7] = (((j + 0) * mMoveX8) >> 3) - (((j - 1) * mMoveX8) >> 3);
////					mStepY[(index + j) & 7] = (((j + 0) * mMoveY8) >> 3) - (((j - 1) * mMoveY8) >> 3);
//					mStepX[j] = mMoveX8 >> 3;
//					mStepY[j] = mMoveY8 >> 3;
//				}
			}
			else {
				int dx = Operation.signX8( x8 - mX8) >> 3;
				int dy = Operation.signY8( y8 - mY8) >> 3;
				if ((mMoveX8 | mMoveY8) == 0) {
					mMoveX8 = dx << 3;
					mMoveY8 = dy << 3;
					for (int j = 0; j < AFlyable.STEP_SIZE; ++j) {
						mStepX[j] = dx;
						mStepY[j] = dy;
					}
				}
				else {
					mMoveX8 -= mStepX[index];
					mMoveY8 -= mStepY[index];
					mMoveX8 += dx;
					mMoveY8 += dy;
					mStepX[index] = dx;
					mStepY[index] = dy;
				}
			}
			mX8 = x8;
			mY8 = y8;
			int hx = 0;
			int hy = 0;
			for (int j = 0; j < index; ++j) {
				hx += mStepX[j];
				hy += mStepY[j];
			}
//			int aktX8 = mX8 - ((index * mMoveX8) & -8) + (index * mMoveX8);
//			int aktY8 = mY8 - ((index * mMoveY8) & -8) + (index * mMoveY8);
			int aktX8 = mX8 + ((index * mMoveX8) & 7);
			int aktY8 = mY8 + ((index * mMoveY8) & 7);
			System.out.print( ", aktX=" + aktX8 + ", aktY=" + aktY8);
			aktX8 -= expX;
			aktY8 -= expY;
			System.out.print( ", (" + aktX8 + "," + aktY8 + ")" + (((aktX8 != 0) || (aktY8 != 0)) ? " ops" : ""));
			System.out.println();
			++sFrame;
		}
	}
}
