package asteroid.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

import asteroid.Operation;

import junit.framework.TestCase;

public class HitTest extends TestCase {
	private static final String TEST = "D:\\Tools\\ct\\output\\hitsShip1.txt";
	private static final int MIN_HIT_DIST = 40;
	private int mFrame;
	private BufferedReader mIS;
	private int[] mMinDistX = new int[17];
	private int[] mMinDistY = new int[17];

	public HitTest( String name) {
		super( name);
	}

	public void atestA() {
		FlyInfo ship = new FlyInfo();
		FlyInfo ufo = new FlyInfo();
		Vector asts = new Vector();
		Vector shots = new Vector();
		try {
			String s = null;
			while ((s = mIS.readLine()) != null) {
				ship.set( 0, 0, 0, 0, 0);
				ufo.set( 0, 0, 0, 0, 0);
				asts.clear();
				shots.clear();
				StringTokenizer st = new StringTokenizer( s);
				if (!st.hasMoreTokens()) {
					continue;
				}
				if (!"Frame".equals( st.nextToken())) { // "Frame"
					continue;
				}
				mFrame = Integer.parseInt( st.nextToken().trim()); // frameNr
				st.nextToken(); // "K:FR__"
				int i = 0;
				while (st.hasMoreTokens()) {
					String detect = st.nextToken();
					StringTokenizer dd = new StringTokenizer( detect, ":,");
					String type = dd.nextToken();
					int x = Integer.parseInt( dd.nextToken().trim());
					int y = Integer.parseInt( dd.nextToken().trim());
					int z = Integer.parseInt( dd.nextToken().trim());
					int moveX = Integer.parseInt( dd.nextToken().trim());
					int moveY = Integer.parseInt( dd.nextToken().trim());
					if ("U".equals( type)) {
						ufo.set( x, y, z, moveX, moveY);
						++i;
					}
					else if ("S".equals( type)) {
						ship.set( x, y, z, moveX, moveY);
						++i;
					}
					else if (type.startsWith( "A")) {
						asts.add( new FlyInfo( x, y, z, moveX, moveY));
						++i;
					}
					else if (type.startsWith( "M")) {
						shots.add( new FlyInfo( x, y, z, moveX, moveY));
						++i;
					}
				}
				System.out.print( "Frame " + mFrame + "  " + i + "  ");
				checkAsteroidShip( asts, ship);
				checkAsteroidShot( asts, shots);
				checkAsteroidUfo( asts, ufo);
				checkShipShot( ship, shots);
				checkShipUfo( ship, ufo);
				checkUfoShot( ufo, shots);
				System.out.println();
//				assertFalse( mModel.isError());
			}
			for (int i = 0; i < 17; ++i) {
				System.out.println( "min for " + i + ":  " + mMinDistX[i] + "  " + mMinDistY[i]);
			}
		}
		catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	void checkAsteroidShip( Vector asts, FlyInfo ship) {
		if (isFly( ship)) {
			for (Iterator i = asts.iterator(); i.hasNext();) {
				FlyInfo ast = (FlyInfo) i.next();
				if (isFly( ast) && isDistance( ast, ship)) {
					print( "A", ast);
					print( "S", ship);
					isHitAsteroidShip( ast, ship);
				}
			}
		}
	}

	void checkAsteroidShot( Vector asts, Vector shots) {
		for (Iterator j = asts.iterator(); j.hasNext();) {
			FlyInfo ast = (FlyInfo) j.next();
			for (Iterator i = shots.iterator(); i.hasNext();) {
				FlyInfo shot = (FlyInfo) i.next();
				if (isFly( ast) && isFly( shot) && isDistance( ast, shot)) {
					print( "A", ast);
					print( "M", shot);
					isHitAsteroidShot( ast, shot);
				}
			}
		}
	}

	void checkAsteroidUfo( Vector asts, FlyInfo ufo) {
		if (isFly( ufo)) {
			for (Iterator i = asts.iterator(); i.hasNext();) {
				FlyInfo ast = (FlyInfo) i.next();
				if (isFly( ast) && isDistance( ast, ufo)) {
					print( "A", ast);
					print( "U", ufo);
					isHitAsteroidUfo( ast, ufo);
				}
			}
		}
	}

	void checkShipShot( FlyInfo ship, Vector shots) {
		if (isFly( ship)) {
			for (Iterator i = shots.iterator(); i.hasNext();) {
				FlyInfo shot = (FlyInfo) i.next();
				if (isFly( shot) && isDistance( ship, shot)) {
					print( "S", ship);
					print( "M", shot);
					isHitShipShot( ship, shot);
				}
			}
		}
	}

	void checkShipUfo( FlyInfo ship, FlyInfo ufo) {
		if (isFly( ship) && isFly( ufo) && isDistance( ship, ufo)) {
			print( "S", ship);
			print( "U", ufo);
			isHitShipUfo( ship, ufo);
		}
	}

	void checkUfoShot( FlyInfo ufo, Vector shots) {
		if (isFly( ufo)) {
			for (Iterator i = shots.iterator(); i.hasNext();) {
				FlyInfo shot = (FlyInfo) i.next();
				if (isFly( shot) && isDistance( ufo, shot)) {
					print( "U", ufo);
					print( "M", shot);
					isHitUfoShot( ufo, shot);
				}
			}
		}
	}

	private boolean isDistance( FlyInfo first, FlyInfo second) {
		int distX = Operation.distX8( first.mX8 - second.mX8);
		int distY = Operation.distY8( first.mY8 - second.mY8);
		return (distX < 1000) && (distY < 1000);
	}

	boolean isFly( FlyInfo fly) {
		return (fly.mX8 != 0) && (fly.mY8 != 0);
	}

	boolean isHitAsteroidShip( FlyInfo ast, FlyInfo ship) {
		int distX8 = Operation.distX8( ast.mX8 - ship.mX8);
		int distY8 = Operation.distY8( ast.mY8 - ship.mY8);
		switch (ast.getZ()) {
			case 0: // grosser Asteroid
				minDistance( 0, distX8, distY8);
				distX8 -= 320;
				distY8 -= 320;
				break;
			case 15: // mittlerer Asteroid
				minDistance( 1, distX8, distY8);
				distX8 -= 160;
				distY8 -= 160;
				break;
			case 14: // kleiner Asteroid
				minDistance( 2, distX8, distY8);
				distX8 -= 64;
				distY8 -= 64;
				break;
		}
		return (distX8 < MIN_HIT_DIST) && (distY8 < MIN_HIT_DIST);
	}

	boolean isHitAsteroidShot( FlyInfo ast, FlyInfo shot) {
		int distX8 = Operation.distX8( ast.mX8 - shot.mX8);
		int distY8 = Operation.distY8( ast.mY8 - shot.mY8);
		switch (ast.getZ()) {
			case 0: // grosser Asteroid
				minDistance( 3, distX8, distY8);
				distX8 -= 320;
				distY8 -= 320;
				break;
			case 15: // mittlerer Asteroid
				minDistance( 4, distX8, distY8);
				distX8 -= 160;
				distY8 -= 160;
				break;
			case 14: // kleiner Asteroid
				minDistance( 5, distX8, distY8);
				distX8 -= 64;
				distY8 -= 64;
				break;
		}
		return ((distX8 < MIN_HIT_DIST) && (distY8 < MIN_HIT_DIST));
	}

	boolean isHitAsteroidUfo( FlyInfo ast, FlyInfo ufo) {
		int distX8 = Operation.distX8( ast.mX8 - ufo.mX8);
		int distY8 = Operation.distY8( ast.mY8 - ufo.mY8);
		switch (ufo.getZ()) {
			case 15: // grosses UFO
				switch (ast.getZ()) {
					case 0: // grosser Asteroid
						minDistance( 6, distX8, distY8);
						distX8 -= 320;
						distY8 -= 320;
						break;
					case 15: // mittlerer Asteroid
						minDistance( 7, distX8, distY8);
						distX8 -= 160;
						distY8 -= 160;
						break;
					case 14: // kleiner Asteroid
						minDistance( 8, distX8, distY8);
						distX8 -= 64;
						distY8 -= 64;
						break;
				}
				distX8 -= 160;
				distY8 -= 96;
				break;
			case 14: // kleines UFO
				switch (ast.getZ()) {
					case 0: // grosser Asteroid
						minDistance( 9, distX8, distY8);
						distX8 -= 320;
						distY8 -= 320;
						break;
					case 15: // mittlerer Asteroid
						minDistance( 10, distX8, distY8);
						distX8 -= 160;
						distY8 -= 160;
						break;
					case 14: // kleiner Asteroid
						minDistance( 11, distX8, distY8);
						distX8 -= 64;
						distY8 -= 64;
						break;
				}
				distX8 -= 80;
				distY8 -= 64;
				break;
		}
		return ((distX8 < MIN_HIT_DIST) && (distY8 < MIN_HIT_DIST));
	}

	boolean isHitShipShot( FlyInfo ship, FlyInfo shot) {
		int distX8 = Operation.distX8( ship.mX8 - shot.mX8);
		int distY8 = Operation.distY8( ship.mY8 - shot.mY8);
		minDistance( 12, distX8, distY8);
		return ((distX8 < 90) && (distY8 < 90));
	}

	boolean isHitShipUfo( FlyInfo ship, FlyInfo ufo) {
		int distX8 = Operation.distX8( ship.mX8 - ufo.mX8);
		int distY8 = Operation.distY8( ship.mY8 - ufo.mY8);
		switch (ufo.getZ()) {
			case 15: // grosses UFO
				minDistance( 13, distX8, distY8);
				distX8 -= 160;
				distY8 -= 96;
				break;
			case 14: // kleines UFO
				minDistance( 14, distX8, distY8);
				distX8 -= 80;
				distY8 -= 64;
				break;
		}
		return ((distX8 < MIN_HIT_DIST) && (distY8 < MIN_HIT_DIST));
	}

	boolean isHitUfoShot( FlyInfo ufo, FlyInfo shot) {
		int distX8 = Operation.distX8( ufo.mX8 - shot.mX8);
		int distY8 = Operation.distY8( ufo.mY8 - shot.mY8);
		switch (ufo.getZ()) {
			case 15: // grosses UFO
				minDistance( 15, distX8, distY8);
				distX8 -= 160;
				distY8 -= 96;
				break;
			case 14: // kleines UFO
				minDistance( 16, distX8, distY8);
				distX8 -= 80;
				distY8 -= 64;
				break;
		}
		return ((distX8 < MIN_HIT_DIST) && (distY8 < MIN_HIT_DIST));
	}

	void minDistance( int index, int distX8, int distY8) {
		if (mMinDistX[index] < distX8) {
			mMinDistX[index] = distX8;
		}
		if (mMinDistY[index] < distY8) {
			mMinDistY[index] = distY8;
		}
		System.out.print( "  distX:" + distX8);
		System.out.print( "  distY:" + distY8);
	}

	static void print( String name, FlyInfo info) {
		System.out.print( "  ");
		System.out.print( name);
		System.out.print( ':');
		System.out.print( info.mX8);
		System.out.print( ',');
		System.out.print( info.mY8);
		System.out.print( ',');
		System.out.print( info.mZ);
		System.out.print( ',');
		System.out.print( info.mMoveX8);
		System.out.print( ',');
		System.out.print( info.mMoveY8);
	}

	protected void tearDown() throws Exception {
		mIS.close();
	}

	public void testB() {
		Asteroid ast = new Asteroid( 0, 2888, 3352, 0, 6, 6);
		Shot shot = new Shot( 3104, 3448, 15, -53, -36);
		assertTrue( Striker.isHitAsteroidShot( ast, shot));
	}

	protected void setUp() throws Exception {
		for (int i = 0; i < 17; ++i) {
			mMinDistX[i] = 0;
			mMinDistY[i] = 0;
		}
		File f = new File( TEST);
		mIS = new BufferedReader( new FileReader( f.getAbsoluteFile()));
	}
}
