package asteroid.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

import asteroid.Player;
import asteroid.PrintWriterFormat;
import asteroid.strategy.measure.AMeasure;
import asteroid.strategy.measure.Rating;
import asteroid.strategy.measure.Stacker;

import junit.framework.TestCase;

public class PriorityTest extends TestCase {
	private BufferedReader mIS;
	private GameModel mModel = new GameModel( null);
	private PrintWriterFormat mOut = new PrintWriterFormat( System.out);
	private Rating mStack = new Rating();
	private Stacker mStacker;

	public PriorityTest( String name) {
		super( name);
	}

	private void print() {
		mOut.savePos();
		mOut.print( GameModel.sFrame);
		mOut.fill( 8);
		for (int i = 0; i <= AsteroidVector.MAX_ASTEROIDS; ++i) {
			AEnemy enemy = mStack.get( i);
			mOut.savePos();
			mOut.print( enemy.getIdent());
			mOut.print( ":");
			if (enemy.isVisible()) {
//				mOut.print( enemy.getDirection());
				mOut.print( Math.round( 10000.0 * enemy.getAlpha()) / 10000.0);
			}
			mOut.fill( 10);
		}
		mOut.println();
	}

	private String readLine() {
		try {
			return mIS.readLine();
		}
		catch (Exception ex) {
			fail( ex.getMessage());
		}
		return null;
	}

	protected void tearDown() throws Exception {
		mIS.close();
	}

	public void testA() {
		String s = null;
		while ((s = readLine()) != null) {
			mModel.parse( s);
			if (GameModel.sFrame >= 275) {
				GameModel.sFrame += 0;
			}
			mStacker.refresh( mModel);
			print();
		}
	}

	protected void setUp() throws Exception {
		File f = new File( Player.POSITION);
		mIS = new BufferedReader( new FileReader( f.getAbsoluteFile()));
		mStack.init( mModel);
		mStacker = new Stacker( mStack, new AMeasure[] { new Init() }, null);
	}

	private class Init extends AMeasure {
		protected void measure( AEnemy enemy) {
			if (enemy.isVisible()) {
				enemy.init( mModel.mShip);
				enemy.mWeight += Angle.toAngle( Math.abs( Angle.signRot( Angle.sRadiant - enemy.getAlpha())));
			}
			else {
				enemy.mWeight += Short.MAX_VALUE;
			}
		}

		protected void print( AEnemy enemy, PrintWriterFormat out) {
		}
	}
}
