package asteroid.model;

import junit.framework.TestCase;

public class ShotVectorTest extends TestCase {
	private Ship mShip = new Ship();
	private Ufo mUfo = new Ufo( mShip);
	private AsteroidVector mAsts = new AsteroidVector( mShip, mUfo);
	private ShotVector mShots = new ShotVector( mShip, mUfo);
	private Detector mDetector = new Detector( mShip, mUfo, mAsts, mShots);

	public ShotVectorTest( String name) {
		super( name);
	}

	private void addShot8( int x8, int y8, int z) {
		mShots.addShot( x8 >> 3, y8 >> 3, z);
	}

	private void checkShot( int index, int x, int y, boolean enemy, int active) {
		Shot s0 = mShots.get( index);
		assertNotNull( s0);
		assertEquals( s0.getState(), active);
		if (active == AFlyable.STATE_VISIBLE) {
			assertEquals( s0.mX8, x << 3);
			assertEquals( s0.mY8, y << 3);
			assertEquals( s0.isShip(), !enemy);
		}
	}

	public void testA() {
		mShots.clearAll();
		mShots.set( 0, 252, 263, 14);
		mShots.set( 1, 338, 284, 14);
		mShots.set( 2, 420, 286, 14);
		mShots.set( 3, 498, 279, 14);
		GameModel.sFrame++;
		mDetector.prepare();
		mShots.addShot( 248, 270, 0);
		mShots.addShot( 336, 292, 0);
		mShots.addShot( 419, 294, 0);
		mShots.addShot( 498, 287, 0);
		mDetector.detect( 0);
		checkShot( 0, 248, 270, false, AFlyable.STATE_VISIBLE);
		checkShot( 1, 336, 292, false, AFlyable.STATE_VISIBLE);
		checkShot( 2, 419, 294, false, AFlyable.STATE_VISIBLE);
		checkShot( 3, 498, 287, false, AFlyable.STATE_VISIBLE);
		GameModel.sFrame++;
		mDetector.prepare();
		mShots.addShot( 546, 619, 0);
		mShots.addShot( 417, 302, 0);
		mShots.addShot( 497, 295, 0);
		mDetector.detect( 0);
		checkShot( 0, 546, 619, false, AFlyable.STATE_VISIBLE);
		checkShot( 1, 0, 0, false, AFlyable.STATE_HIDDEN);
		checkShot( 2, 417, 302, false, AFlyable.STATE_VISIBLE);
		checkShot( 3, 497, 295, false, AFlyable.STATE_VISIBLE);
	}

	public void testB() {
		mShots.clearAll();
		mShots.set( 0, 222, 620, 14);
		mShots.set( 1, 155, 603, 14);
		mShots.set( 2, 146, 587, 14);
		mShots.set( 3, 311, 656, 14);
		GameModel.sFrame++;
		mDetector.prepare();
		mShots.addShot( 228, 630, 0);
		mShots.addShot( 151, 597, 0);
		mShots.addShot( 319, 665, 0);
		mDetector.detect( 0);
		checkShot( 0, 228, 630, false, AFlyable.STATE_VISIBLE);
		checkShot( 1, 151, 597, false, AFlyable.STATE_VISIBLE);
		checkShot( 2, 0, 0, false, AFlyable.STATE_HIDDEN);
		checkShot( 3, 319, 665, false, AFlyable.STATE_VISIBLE);
		GameModel.sFrame++;
		mDetector.prepare();
		mShots.addShot( 235, 640, 0);
		mShots.addShot( 156, 607, 0);
		mShots.addShot( 91, 209, 0);
		mShots.addShot( 326, 675, 0);
		mDetector.detect( 0);
		checkShot( 0, 235, 640, false, AFlyable.STATE_VISIBLE);
		checkShot( 1, 156, 607, false, AFlyable.STATE_VISIBLE);
		checkShot( 2, 91, 209, false, AFlyable.STATE_VISIBLE);
		checkShot( 3, 326, 675, false, AFlyable.STATE_VISIBLE);
	}

	public void testC() {
		GameModel.sFrame++;
		mDetector.prepare();
		mShots.addShot( 857, 510, 0);
		mDetector.detect( 0);
		checkShot( 0, 857, 510, false, AFlyable.STATE_VISIBLE);
		GameModel.sFrame++;
		mDetector.prepare();
		mShots.addShot( 847, 511, 0);
		mDetector.detect( 0);
		checkShot( 0, 847, 511, false, AFlyable.STATE_VISIBLE);
		GameModel.sFrame++;
		mDetector.prepare();
		mShots.addShot( 837, 513, 0);
		mDetector.detect( 0);
		checkShot( 0, 837, 513, false, AFlyable.STATE_VISIBLE);
		GameModel.sFrame++;
		mDetector.prepare();
		mShots.addShot( 827, 515, 0);
		mDetector.detect( 0);
		checkShot( 0, 827, 515, false, AFlyable.STATE_VISIBLE);
	}

	public void testD() {
		mShots.clearAll();
		mShots.set( 0, 674, 136, 14);
		mShots.set( 1, 548, 136, 14);
		mShots.set( 2, 467, 272, 14);
		mShots.set( 3, 453, 210, 14);
		GameModel.sFrame++;
		mDetector.prepare();
		mShots.addShot( 677, 129, 0);
		mShots.addShot( 548, 128, 0);
		mShots.addShot( 465, 264, 0);
		mShots.addShot( 451, 202, 0);
		mDetector.detect( 0);
		checkShot( 0, 677, 129, false, AFlyable.STATE_VISIBLE);
		checkShot( 1, 548, 128, false, AFlyable.STATE_VISIBLE);
		checkShot( 2, 465, 264, false, AFlyable.STATE_VISIBLE);
		checkShot( 3, 451, 202, false, AFlyable.STATE_VISIBLE);
		GameModel.sFrame++;
		mDetector.prepare();
		mShots.addShot( 680, 890, 0);
		mShots.addShot( 549, 888, 0);
		mShots.addShot( 463, 256, 0);
		mShots.addShot( 449, 194, 0);
		mDetector.detect( 0);
		checkShot( 0, 680, 890, false, AFlyable.STATE_VISIBLE);
		checkShot( 1, 549, 888, false, AFlyable.STATE_VISIBLE);
		checkShot( 2, 463, 256, false, AFlyable.STATE_VISIBLE);
		checkShot( 3, 449, 194, false, AFlyable.STATE_VISIBLE);
	}

	// 110,7
	public void testE() {
		mShots.clearAll();
		mShots.set8( 0, 4344, 4200, 15);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 4408, 4200, 15);
		mDetector.detect( 0);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 4472, 4208, 15);
		mDetector.detect( 0);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 4536, 4208, 15);
		mDetector.detect( 0);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 4600, 4216, 15);
		mDetector.detect( 0);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 4664, 4216, 15);
		mDetector.detect( 0);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 4720, 4224, 15);
		mDetector.detect( 0);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 4784, 4224, 15);
		mDetector.detect( 0);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 4848, 4232, 15);
		mDetector.detect( 0);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 4912, 4232, 15);
		mDetector.detect( 0);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 4976, 4240, 15);
		mDetector.detect( 0);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 5040, 4240, 15);
		mDetector.detect( 0);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 5104, 4248, 15);
		mDetector.detect( 0);
		GameModel.sFrame++;
		mDetector.prepare();
		addShot8( 5168, 4248, 15);
		mDetector.detect( 0);
	}

	protected void setUp() throws Exception {
		GameModel.sFrame = 0;
	}
}
