package asteroid.model;

import junit.framework.TestCase;
import asteroid.PrintWriterFormat;

public class TargetTest extends TestCase {
	private GameModel mModel = new GameModel( null);
	private PrintWriterFormat mOut = new PrintWriterFormat( System.out);

	public TargetTest( String name) {
		super( name);
	}

	private void showAsts() {
		for (int i = 0; i < AsteroidVector.MAX_ASTEROIDS; ++i) {
			Asteroid ast = mModel.mAsts.get( i);
			if (ast.isVisible()) {
				showEnemy( ast);
			}
		}
		mOut.println();
	}

	private void showEnemy( AEnemy enemy) {
		enemy.setDirection( mModel.mShip, Angle.sForward);
		mOut.savePos();
		mOut.print( enemy.getIdent());
		mOut.print( " direction=");
		mOut.print( enemy.getDirection());
		mOut.fill( 16);
		mOut.print( " dispRot=");
		mOut.print( Angle.distRot( enemy.getDirection() - Angle.sDirection));
		mOut.fill( 12);
		mOut.print( " alpha=");
		mOut.print( enemy.getAlpha());
		mOut.fill( 28);
		mOut.println();
	}

	public void testA() {
		mModel.parse( "272,______,016,017,000,1,253,003    S:4192,4192,12,0,0,1.       a0:1864,5432,0,0,0,..       a1:6320,5040,0,0,0,..       a2:6320,1712,0,0,0,..       a3:7240,2888,0,0,0,..       a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "273,______,017,018,000,1,253,003    S:4192,4192,12,0,0,..       A0:8184,2872,0,0,0,1.       A1:8,4776,0,0,0,1.          A2:7600,1032,0,0,0,1.       A3:6728,7160,0,0,0,1.       a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "274,____L_,018,019,003,1,253,003    S:4192,4192,12,0,0,..       A0:8176,2864,0,-8,-8,..     A1:24,4768,0,16,-8,..       A2:7608,1048,0,8,16,..      A3:6720,7152,0,-8,-8,..     a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "275,____L_,019,020,006,1,253,003    S:4192,4192,12,0,0,..       A0:8168,2856,0,-8,-8,..     A1:32,4760,0,15,-8,..       A2:7616,1056,0,8,15,..      A3:6712,7144,0,-8,-8,..     a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "276,____L_,020,021,003,1,004,007    S:4192,4192,12,0,0,..       A0:8168,2848,0,-7,-8,..     A1:48,4760,0,15,-7,..       A2:7624,1072,0,8,15,..      A3:6712,7144,0,-7,-7,..     a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "277,____L_,021,022,000,1,008,011    S:4192,4192,12,0,0,..       A0:8160,2840,0,-7,-8,..     A1:56,4752,0,14,-7,..       A2:7624,1088,0,7,15,..      A3:6704,7136,0,-7,-7,..     a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "278,____L_,022,023,253,1,012,015    S:4192,4192,12,0,0,..       A0:8152,2832,0,-7,-8,..     A1:72,4744,0,14,-7,..       A2:7632,1096,0,7,14,..      A3:6696,7128,0,-7,-7,..     a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "279,____L_,023,024,250,1,012,015    S:4192,4192,12,0,0,..       A0:8144,2824,0,-7,-8,..     A1:80,4736,0,13,-7,..       A2:7640,1112,0,7,14,..      A3:6688,7120,0,-7,-7,..     a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "280,____L_,024,025,247,1,016,019    S:4192,4192,12,0,0,..       A0:8144,2816,0,-6,-8,..     A1:96,4736,0,13,-6,..       A2:7648,1128,0,7,14,..      A3:6688,7120,0,-6,-6,..     a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "281,____L_,025,026,244,1,020,023    S:4192,4192,12,0,0,..       A0:8136,2800,0,-6,-9,..     A1:104,4728,0,12,-6,..      A2:7648,1136,0,6,13,..      A3:6680,7112,0,-6,-6,..     a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "282,____L_,026,027,241,1,024,027    S:4192,4192,12,0,0,..       A0:8128,2792,0,-6,-9,..     A1:120,4720,0,12,-6,..      A2:7656,1152,0,6,13,..      A3:6672,7104,0,-6,-6,..     a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "283,____L_,027,028,238,1,024,027    S:4192,4192,12,0,0,..       A0:8120,2784,0,-6,-9,..     A1:128,4712,0,12,-6,..      A2:7664,1160,0,6,13,..      A3:6664,7096,0,-6,-6,..     a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "284,____L_,028,029,235,1,028,031    S:4192,4192,12,0,0,..       A0:8120,2776,0,-6,-9,..     A1:144,4712,0,12,-6,..      A2:7672,1176,0,6,13,..      A3:6664,7096,0,-6,-6,..     a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
		mModel.parse( "285,____L_,029,030,235,1,032,035    S:4192,4192,12,0,0,..       A0:8112,2768,0,-6,-9,..     A1:152,4704,0,12,-6,..      A2:7672,1192,0,6,13,..      A3:6656,7088,0,-6,-6,..     a4:0,0,0,0,0,..             a5:0,0,0,0,0,..             a6:0,0,0,0,0,..             a7:0,0,0,0,0,..             a8:0,0,0,0,0,..             a9:0,0,0,0,0,..             a10:0,0,0,0,0,..            a11:0,0,0,0,0,..            a12:0,0,0,0,0,..            a13:0,0,0,0,0,..            a14:0,0,0,0,0,..            a15:0,0,0,0,0,..            a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            u:0,0,0,0,0,..              _0:0,0,0,0,0,..             _1:0,0,0,0,0,..             _2:0,0,0,0,0,..             _3:0,0,0,0,0,..             _4:0,0,0,0,0,..             _5:0,0,0,0,0,..             ");
		showAsts();
	}
}
