package asteroid.strategy;

import asteroid.Operation;
import asteroid.model.Angle;
import asteroid.model.FlyInfo;

import junit.framework.TestCase;

public class PriorityTest extends TestCase {
	public PriorityTest( String name) {
		super( name);
	}

	private void assertPosShot( int angle, int dx, int dy) {
		assertEquals( dx, Angle.posShotX( angle));
		assertEquals( dy, Angle.posShotY( angle));
	}

	private void getMinDist2( FlyInfo shot, FlyInfo ast) {
		int dx = Operation.signX8( ast.getX8() - shot.getX8());
		int dy = Operation.signY8( ast.getY8() - shot.getY8());
		int dvx = ast.getMoveX8() - shot.getMoveX8();
		int dvy = ast.getMoveY8() - shot.getMoveY8();
		double v = (dvx * dvx) + (dvy * dvy);
		double dd = (dx * dvy) - (dy * dvx);
		System.out.println( Math.sqrt( dd * dd / v));
	}

	public void testA() {
		int angle = 3;
		int sx = 4960 + Angle.posShotX( angle);
		int sy = 4704 + Angle.posShotY( angle);
		int vx = Angle.vShotX( angle);
		int vy = Angle.vShotY( angle);
		getMinDist2( new FlyInfo( sx, sy, 15, vx, vy), new FlyInfo( 64, 5432, 15, +6, -6));
		getMinDist2( new FlyInfo( 5112, 4712, 15, +63, +4), new FlyInfo( 64, 5432, 15, +6, -6));
		getMinDist2( new FlyInfo( 5552, 4736, 15, +63, +4), new FlyInfo( 112, 5392, 15, +6, -6));
		getMinDist2( new FlyInfo( 5936, 4760, 15, +63, +4), new FlyInfo( 144, 5360, 15, +6, -6));
		getMinDist2( new FlyInfo( 6312, 4784, 15, +63, +4), new FlyInfo( 184, 5320, 15, +6, -6));
		angle = 232;
		sx = 4960 + Angle.posShotX( angle);
		sy = 4704 + Angle.posShotY( angle);
		vx = Angle.vShotX( angle);
		vy = Angle.vShotY( angle);
	}

	public void testB() {
		assertPosShot( 0, 152, 0);
		assertPosShot( 3, 152, 8);
		assertPosShot( 27, 120, 96);
		assertPosShot( 33, 104, 112);
		assertPosShot( 45, 64, 136);
		assertPosShot( 63, 0, 152);
		assertPosShot( 111, -152, 56);
		assertPosShot( 150, -144, -88);
		assertPosShot( 232, 128, -96);
		assertPosShot( 244, 152, -48);
	}
}
