package asteroid.model;

public class Magazine extends ACompute {
//	private static final int MAX_FRAME_WAIT = 20;
	private int mFire, mShots, mFireDirection;
	private int mMaxTimeWait = Angle.sForward << 2;
	private int[] mPivot = new int[Shot.MAX_SHIP_SHOTS];
	private Target[] mTargets = new Target[Shot.MAX_SHIP_SHOTS];

	public Magazine() {
		for (int i = 0; i < Shot.MAX_SHIP_SHOTS; ++i) {
			mTargets[i] = new Target();
			mPivot[i] = -1;
		}
	}

	public boolean addFire( AEnemy enemy) {
		for (int i = 0; i < Shot.MAX_SHIP_SHOTS; ++i) {
			Target t = mTargets[i];
			if ((t.mShot == null) && (t.mEnemy == null)) {
				enemy.decFire();
				t.mEnemy = enemy;
				t.mTimeOut = mMaxTimeWait;
				mFire = 1;
				return true;
			}
		}
		return false;
	}

	public void addFire( AEnemy enemy, boolean multi) {
		if ((mFire == 0) && (multi || !isTaget( enemy))) {
			addFire( enemy);
		}
	}

	public boolean canFire() {
		return mFire == 0;
	}

	public void cleanup( GameModel model) {
		mMaxTimeWait = Angle.sForward << 2;
		mFireDirection = model.getFireDirection();
		mShots = 0;
		model.forUfo( this);
		model.forAllAsteroids( this);
		model.forAllShots( this);
	}

	private void clearShot( Target t) {
		if (t.mShot != null) {
			mPivot[t.mShot.getIndex()] = -1;
		}
		t.mShot = null;
	}

	public boolean isFire() {
		return mFire == 1;
	}

	public void forAsteroid( Asteroid ast) {
		forEnemy( ast);
	}

	private void forEnemy( AEnemy enemy) {
		boolean missing = true;
		for (int i = 0; i < Shot.MAX_SHIP_SHOTS; ++i) {
			Target t = mTargets[i];
			if (t.mEnemy == enemy) {
				missing = false;
				if (!enemy.isVisible()) {
					enemy.initFire();
					t.mEnemy = null;
				}
				else if ((t.mShot == null) && (t.mTimeOut > 0)) {
					--t.mTimeOut;
				}
				if (t.mTimeOut <= 0) {
					enemy.initFire();
					t.mEnemy = null;
				}
			}
		}
		if (missing && enemy.isVisible()) {
			enemy.initFire();
		}
	}

	public void forShot( Shot shot) {
		if (shot.isShip()) {
			if ((shot.getVanish() > 0) || shot.isHidden()) {
				int i = mPivot[shot.getIndex()];
				if (i >= 0) {
					Target t = mTargets[i];
					if (t.mEnemy != null) {
						t.mEnemy.initFire();
						t.mEnemy = null;
					}
					clearShot( t);
					moveTarget( t, i + 1);
				}
				shot.mHitTime = Integer.MAX_VALUE;
			}
			if (shot.getCreate() > 0) {
				for (int i = 0; i < Shot.MAX_SHIP_SHOTS; ++i) {
					Target t = mTargets[i];
					if (t.mShot == null) {
						setShot( t, shot, i);
						t.mDirection = mFireDirection;
						break;
					}
				}
			}
			if (shot.isVisible()) {
				++mShots;
//				preView(shot);
			}
		}
	}

	public void forUfo( Ufo ufo) {
		forEnemy( ufo);
	}

	public static double hitTime( Shot shot, AEnemy enemy) {
		int det = (shot.mMoveX8 * enemy.mMoveY8) - (shot.mMoveY8 * enemy.mMoveX8);
		if (det == 0) {
			return Integer.MAX_VALUE; // beide fliegen parallel
		}
		double dt = ((enemy.mX8 - shot.mX8) * enemy.mMoveY8) - ((enemy.mY8 - shot.mY8) * enemy.mMoveX8);
		return dt / det;
	}

	public static double hitTime2( Shot shot, AEnemy enemy) {
		int dvx = enemy.mMoveX8 - shot.mMoveX8;
		int dvy = enemy.mMoveY8 - shot.mMoveY8;
		int dv = (dvx * dvx) + (dvy * dvy);
		if (dv == 0) {
			return Integer.MAX_VALUE;
		}
		double k3 = enemy.sizeX() * enemy.sizeY() * dv;
		int dx = enemy.mX8 - shot.mX8;
		int dy = enemy.mY8 - shot.mY8;
		int k2 = (dx * dvy) - (dy * dvx);
		double k4 = k2 * k2;
		k3 -= k4;
		if (k3 < 0) {
			return Integer.MAX_VALUE;
		}
		double k1 = (dx * dvx) + (dy * dvy);
		double k5 = Math.sqrt( k3);
		double k6 = -k1 + k5;
		double k7 = -k1 - k5;
		if (k7 < k6) {
			return k7 / dv;
		}
		return k6 / dv;
	}

	public int getKey() {
		return (mFire == 1) ? KEY_FIRE : 0;
	}

	private void moveTarget( Target t, int pos) {
		for (int i = pos; i < Shot.MAX_SHIP_SHOTS; ++i) {
			setTarget( i - 1, mTargets[i]);
		}
		setTarget( Shot.MAX_SHIP_SHOTS - 1, t);
	}

	public void prepareFire() {
		mFire = (mFire << 1) & 3;
	}

	void preView( Shot shot) {
		int i = mPivot[shot.getIndex()];
		if (i >= 0) {
			Target t = mTargets[i];
			if (t.mEnemy != null) {
				shot.mHitTime = hitTime2( shot, t.mEnemy);
				if (shot.mHitTime <= Angle.sForward) {
					t.mEnemy.decFire();
					t.mEnemy.decFire();
					t.mEnemy = null;
					clearShot( t);
					moveTarget( t, i + 1);
				}
			}
		}
	}

	private void setShot( Target t, Shot shot, int pos) {
		t.mShot = shot;
		mPivot[shot.getIndex()] = pos;
	}

	public int getShots() {
		return mShots;
	}

	public boolean isTaget( AEnemy enemy) {
		for (int i = 0; i < Shot.MAX_SHIP_SHOTS; ++i) {
			if (mTargets[i].mEnemy == enemy) {
				return true;
			}
		}
		return false;
	}

	private void setTarget( int pos, Target t) {
		mTargets[pos] = t;
		if (t.mShot != null) {
			mPivot[t.mShot.getIndex()] = pos;
		}
	}

	private static class Target {
		int mDirection;
		AEnemy mEnemy;
		Shot mShot;
		int mTimeOut;
	}
}
