package asteroid.printer;

import java.io.PrintStream;

import asteroid.model.AEnemy;
import asteroid.model.AFlyable;
import asteroid.model.Asteroid;
import asteroid.model.AsteroidVector;
import asteroid.model.GameModel;
import asteroid.model.Shot;
import asteroid.model.ShotVector;
import asteroid.model.Ufo;

public class Collision extends APrinter {
	private int[][] mHitDist = new int[ShotVector.MAX_SHOTS][AsteroidVector.MAX_ASTEROIDS];
	private int[][] mHitTime = new int[ShotVector.MAX_SHOTS][AsteroidVector.MAX_ASTEROIDS];
	private RememberModel mLast = new RememberModel();
	private double[] mMaxSize = new double[4];
	private int[] mMinDist = new int[ShotVector.MAX_SHOTS];
	private int[] mMinObj = new int[ShotVector.MAX_SHOTS];
	private int[] mMinTime = new int[ShotVector.MAX_SHOTS];
	private GameModel mModel;
	private Shot mShot;

	public Collision( GameModel model, PrintStream ps) {
		super( ps);
		mModel = model;
	}

	public Collision( GameModel model, String file) {
		super( file);
		mModel = model;
	}

	void findCollision() {
		for (int i = 0; i < ShotVector.MAX_SHOTS; ++i) {
			mMinDist[i] = Integer.MAX_VALUE;
			mMinTime[i] = Integer.MAX_VALUE;
			mMinObj[i] = -1;
		}
		for (int i = 0; i < ShotVector.MAX_SHOTS; ++i) {
			for (int j = 0; j < AsteroidVector.MAX_ASTEROIDS; ++j) {
				int t = mHitTime[i][j];
				int d = mHitDist[i][j];
				if ((d < mMinDist[i]) || ((d == mMinDist[i]) && (t < mMinTime[i]))) {
					mMinDist[i] = d;
					mMinTime[i] = t;
					mMinObj[i] = j;
				}
			}
		}
		for (int i = 0; i < ShotVector.MAX_SHOTS; ++i) {
			mOut.savePos();
			mOut.print( 'M');
			mOut.print( i);
			mOut.print( ':');
			if ((mMinTime[i] < Integer.MAX_VALUE) && (mMinDist[i] < Integer.MAX_VALUE)) {
				mOut.print( mMinTime[i] / 100);
				mOut.print( ',');
				mOut.print( mMinDist[i] / 100);
				mOut.print( ':');
				mOut.print( 'A');
				mOut.print( mMinObj[i]);
			}
			mOut.fill( 16);
		}
		mOut.println();
	}

	public void forAsteroid( Asteroid ast) {
		mOut.savePos();
		if (mShot == null) {
			mOut.print( ast.getIdent());
			mOut.print( ':');
			if (ast.isVisible()) {
				forFlyable( ast);
			}
		}
		else {
			mOut.print( ':');
			if ((ast.isVisible()) && (mShot.isVisible())) {
//				test1( enemy);
				test2( ast);
			}
			else {
				mHitDist[mShot.getIndex()][ast.getIndex()] = Integer.MAX_VALUE;
				mHitTime[mShot.getIndex()][ast.getIndex()] = Integer.MAX_VALUE;
			}
		}
//		if (ast.isExplosion()) {
//			Remember remAst = mLast.mAsts[ast.getIndex()];
//			Remember remShot = mLast.mShots[mShot.getIndex()];
//			if (!remAst.isExplosion() && remShot.isActive()) {
//				test3( remAst, remShot);
//			}
//		}
		mOut.fill( 20);
	}

	void forFlyable( AFlyable fly) {
		mOut.print( fly.getX8());
		mOut.print( ',');
		mOut.print( fly.getY8());
		mOut.print( ',');
		mOut.print( fly.getMoveX8());
		mOut.print( ',');
		mOut.print( fly.getMoveY8());
	}

	public void forShot( Shot shot) {
		mOut.savePos();
		mOut.print( shot.getIdent());
		mOut.print( ':');
		if (shot.isVisible()) {
			forFlyable( shot);
		}
		mOut.fill( 24);
		mShot = shot;
		mModel.forUfo( this);
		mModel.forAllAsteroids( this);
		mOut.println();
	}

	public void forUfo( Ufo ufo) {
//		mPrint.print( ufo.getIdent());
//		mPrint.print( ':');
//		forEnemy( ufo);
	}

	void printMaxSize() {
		for (int i = 0; i < 4; ++i) {
			mOut.savePos();
			mOut.print( mMaxSize[i]);
			mOut.fill( 20);
		}
		mOut.println();
	}

	public void print() {
		if (mModel.getShip().isVisible()) {
			mShot = null;
			mOut.savePos();
			mOut.fill( 24);
			mModel.forAllAsteroids( this);
			mOut.println();
			mModel.forAllShots( this);
			mModel.forAllAsteroids( mLast);
			mModel.forAllShots( mLast);
			findCollision();
			mOut.println();
//			printMaxSize();
		}
	}

	void test1( AEnemy enemy) {
		int dd = (mShot.getMoveX8() * enemy.getMoveY8()) - (mShot.getMoveY8() * enemy.getMoveX8());
		if (dd == 0) {
			mOut.print( "parallel");
		}
		else {
			int dx = enemy.getX8() - mShot.getX8();
			int dy = enemy.getY8() - mShot.getY8();
			double kShot = (double) ((dx * enemy.getMoveY8()) - (dy * enemy.getMoveX8())) / dd;
			double kEnemy = (double) ((dx * mShot.getMoveY8()) - (dy * mShot.getMoveX8())) / dd;
			mOut.print( (int) Math.round( kShot));
			mOut.print( ',');
			mOut.print( (int) Math.round( kEnemy));
		}
	}

	void test2( Asteroid ast) {
		int dx = ast.getX8() - mShot.getX8();
		int dy = ast.getY8() - mShot.getY8();
		int dMoveX = ast.getMoveX8() - mShot.getMoveX8();
		int dMoveY = ast.getMoveY8() - mShot.getMoveY8();
		int dMove2 = (dMoveX * dMoveX) + (dMoveY * dMoveY);
		if (dMove2 != 0) {
			int t = -100 * ((dx * dMoveX) + (dy * dMoveY)) / dMove2;
			long dd = 100 * ((dx * dMoveY) - (dy * dMoveX));
			long ds = dd * dd / dMove2;
			ds = (long) Math.sqrt( ds);
			if ((t > 0) && (ds < Integer.MAX_VALUE)) {
				mHitDist[mShot.getIndex()][ast.getIndex()] = (int) ds;
				mHitTime[mShot.getIndex()][ast.getIndex()] = t;
				mOut.print( t / 100);
				mOut.print( ',');
				mOut.print( ds / 100);
				return;
			}
		}
		mHitDist[mShot.getIndex()][ast.getIndex()] = Integer.MAX_VALUE;
		mHitTime[mShot.getIndex()][ast.getIndex()] = Integer.MAX_VALUE;
	}

	void test3( Remember enemy, Remember remShot) {
		int dx = enemy.mX8 - remShot.mX8;
		int dy = enemy.mY8 - remShot.mY8;
		int dMoveX = enemy.mMoveX8 - remShot.mMoveX8;
		int dMoveY = enemy.mMoveY8 - remShot.mMoveY8;
		int dMove2 = (dMoveX * dMoveX) + (dMoveY * dMoveY);
		if (dMove2 != 0) {
			int t = -((dx * dMoveX) + (dy * dMoveY)) / dMove2;
			long dd = (dx * dMoveY) - (dy * dMoveX);
			long ds = dd * dd / dMove2;
			ds = (int) Math.sqrt( ds);
			if ((t > 0) && (ds < 600.0)) {
				mOut.print( 'x');
				switch (enemy.mZ) {
					case 0:
						if (mMaxSize[0] < ds) {
							mMaxSize[0] = ds;
						}
						break;
					case 15:
						if (mMaxSize[1] < ds) {
							mMaxSize[1] = ds;
						}
						break;
					case 14:
						if (mMaxSize[2] < ds) {
							mMaxSize[2] = ds;
						}
						break;
					default:
						if (mMaxSize[3] < ds) {
							mMaxSize[3] = ds;
						}
				}
			}
		}
	}
}
