package asteroid.statistic;

public class AverageInt {
	private int mAverage;
	private int mMask;
	private int mPos;
	private int mRound;
	private int mShift;
	private int mSum;
	private int[] mValues;

	public AverageInt( int dim) {
		mShift = dim;
		int size = 1 << dim;
		mValues = new int[size];
		mMask = size - 1;
		mRound = size >> 1;
		mSum = mRound;
	}

	public void addValue( int value) {
		setValue( mPos++, value);
	}

	public int getAverage() {
		return mAverage;
	}

	public double getMean() {
		return (double) getSum() / mValues.length;
	}

	public void reset() {
		for (int i = 0; i < mValues.length; ++i) {
			mValues[i] = 0;
		}
		mAverage = 0;
		mSum = mRound;
	}

	public int getSum() {
		return mSum - mRound;
	}

	public void setValue( int pos, int value) {
		pos &= mMask;
		mSum -= mValues[pos];
		mSum += value;
		mValues[pos] = value;
		mAverage = mSum >> mShift;
	}
}
