package asteroid.strategy;

import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Shot;
import asteroid.model.Ufo;

public class Permutation extends AStrategie {
	private Genom mBest;
	private int mEndFrame;
	private int mFirst, mLast;
	private int mMaxTimeWait = Angle.sForward << 2;
	private Genom mPerm;

	public Permutation( GameModel model) {
		super( model);
		mBest = new Genom( model);
		mPerm = new Genom( model);
	}

	public void cleanup() {
		mMaxTimeWait = Angle.sForward << 2;
		mModel.forUfo( this);
		mModel.forAllAsteroids( this);
		mModel.forAllShots( this);
		for (int i = 0; i < mFirst; ++i) {
			Gen gen = mBest.get( i);
			if ((gen.mShot == null) && (gen.mTimeOut > 0)) {
				--gen.mTimeOut;
			}
			if (gen.mTimeOut <= 0) {
				int id = gen.mEnemy.getID();
				mBest.moveEnemy( mLast - 1, id);
				mPerm.moveEnemy( mLast - 1, id);
				--mFirst;
			}
		}
		mBest.calculate( mFirst, mLast);
		mEndFrame = mBest.getEndFrame();
	}

	public void forAsteroid( Asteroid ast) {
		forEnemy( ast);
	}

	private void forEnemy( AEnemy enemy) {
		if (enemy.getVanish() > 0) {
			int id = enemy.getID();
			--mLast;
			mBest.moveEnemy( mLast, id);
			mPerm.moveEnemy( mLast, id);
		}
		if (enemy.getCreate() > 0) {
			mBest.setEnemy( mLast, enemy);
			mPerm.setEnemy( mLast, enemy);
			++mLast;
		}
	}

	public void forShot( Shot shot) {
		if (shot.isShip()) {
			if ((shot.getVanish() > 0) || shot.isHidden()) {
				for (int i = 0; i < mFirst; ++i) {
					Gen gen = mBest.get( i);
					if (gen.mShot == shot) {
						int id = gen.mEnemy.getID();
						mBest.moveEnemy( mLast - 1, id);
						mPerm.moveEnemy( mLast - 1, id);
						break;
					}
				}
			}
			if (shot.getCreate() > 0) {
				for (int i = 0; i < mFirst; ++i) {
					Gen gen = mBest.get( i);
					if (gen.mShot == null) {
						gen.mShot = shot;
						break;
					}
				}
			}
		}
	}

	public void forUfo( Ufo ufo) {
		forEnemy( ufo);
	}

	public int getKey() {
		if (mFirst >= mLast) {
			return 0;
		}
		Gen gen = mBest.get( mFirst);
		int key = gen.mInfo.getRot( gen.mEnemy);
		if ((key == 0) && (gen.mInfo.getWait() == 0)) {
			key |= KEY_FIRE;
			gen.mTimeOut = mMaxTimeWait;
			mPerm.moveEnemy( mLast - 1, gen.mEnemy.getID(), mFirst);
			++mFirst;
			if (mFirst < mLast) {
				Gen gen2 = mBest.get( mFirst);
				key |= gen2.mInfo.getRot( gen2.mEnemy);
			}
		}
		return key;
	}

	public void refresh() {
		mPerm.next( mFirst, mLast);
		mPerm.calculate( mFirst, mLast);
		int endFrame = mPerm.getEndFrame();
		if (endFrame < mEndFrame) {
			mBest.update( mFirst, mLast, mPerm);
			mEndFrame = endFrame;
		}
	}
}
