package asteroid.strategy;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.GameModel;
import asteroid.model.Magazine;
import asteroid.model.TargetInfo;
import asteroid.strategy.measure.AMeasure;
import asteroid.strategy.measure.Count;
import asteroid.strategy.measure.FireTime;
import asteroid.strategy.measure.Intersect;
import asteroid.strategy.measure.Modify;
import asteroid.strategy.measure.Rating;
import asteroid.strategy.measure.RotTime;
import asteroid.strategy.measure.Stacker;
import asteroid.strategy.measure.UfoFirst;

public class Priority extends AStrategie {
	private Magazine mMagazine = new Magazine();
	private PrintWriterFormat mOut;
	private Rating mRating = new Rating();
	private Stacker mStacker;

	public Priority( GameModel model) {
		super( model);
//		mOut = new PrintWriterFormat( System.out);
		mRating.init( model);
		mStacker = new Stacker( mRating, new AMeasure[] {
				new RotTime( mModel.getShip(), 1.0),
			new Intersect( mModel.getShip(), 0.0005),
			new FireTime( 0.01),
			new Modify( 50),
			new Count(),
			new UfoFirst( 60.0)
			}, mOut);
	}

	public void cleanup() {
		mMagazine.cleanup( mModel);
	}

	private void handleFire( AEnemy enemy) {
		TargetInfo info = enemy.getInfo();
		if ((info.getRot() == 0) && (info.getWait() == 0)) {
			if (enemy.canFire() && mMagazine.canFire()) {
				if (!mMagazine.addFire( enemy) && enemy.isFired()) {
					enemy.decFire();
				}
			}
		}
		else if (enemy.isFired()) {
			enemy.decFire();
		}
	}

	public int getKey() {
		if (mModel.isShipVisible()) {
			return getRot() | mMagazine.getKey();
		}
		else {
			return 0;
		}
	}

	public void refresh() {
		mStacker.refresh( mModel);
		mMagazine.prepareFire();
		if (GameModel.sFrame >= 1090) {
			GameModel.sFrame += 0;
		}
		if (mModel.getShip().isVisible()) {
			AEnemy first = mRating.getFirst();
			if (first.isVisible()) {
				handleFire( first);
			}
		}
	}

	private int getRot() {
		AEnemy first = mRating.getFirst();
		if (first.isVisible()) {
			AEnemy second = mRating.getSecond();
			if (second.isVisible() && !first.canFire()) {
				return second.getInfo().getRot( second);
			}
			else {
				return first.getInfo().getRot( first);
			}
		}
		return 0;
	}
}
