package asteroid.strategy;

import asteroid.model.GameModel;
import asteroid.model.Shot;

public class Rotate extends AStrategie {
	private int mKey;

	public Rotate( GameModel model) {
		super( model);
	}

	public void cleanup() {
	}

	public void forShot( Shot shot) {
		if (shot.getIndex() == 0) {
			if (shot.isVisible()) {
				mKey = (shot.getModify() == 20) ? KEY_LEFT : 0;
			}
			if (shot.isHidden()) {
				mKey = KEY_FIRE;
			}
		}
	}

	public int getKey() {
		return mModel.isShipVisible() ? mKey : 0;
	}

	public void refresh() {
		if (mModel.getShip().isVisible()) {
			mModel.forAllShots( this);
		}
	}
}
