package asteroid.strategy.measure;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.Angle;

public class DeltaDirection extends AMeasure {
	private int mDelta;
	private int mWeight;

	public DeltaDirection( int delta, int weight) {
		mDelta = delta;
		mWeight = weight;
	}

	protected void measure( AEnemy enemy) {
		int dist = Angle.distRot( enemy.getDirection() - Angle.sDirection);
		if (dist > mDelta) {
			enemy.mWeight += mWeight;
		}
	}

	protected void print( AEnemy enemy, PrintWriterFormat out) {
	}
}
