package asteroid.strategy.measure;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;

public class FireTime extends AMeasure {
	private double mFakt;

	public FireTime( double fakt) {
		mFakt = fakt;
	}

	protected void measure( AEnemy enemy) {
		int time = enemy.getInfo().getFireTime();
		if (time > 69) {
			enemy.mWeight += MAX_IGNORE;
		}
		else if (time > 32) {
			time -= 32;
			double dt = mFakt * time;
			enemy.mWeight += dt;
		}
	}

	protected void print( AEnemy enemy, PrintWriterFormat out) {
		int time = enemy.getInfo().getFireTime();
		if (time > 69) {
			out.print( "max");
		}
		else if (time > 32) {
			out.print( time);
			out.print( ':');
			out.print( Math.round( 1000.0 * mFakt * time) / 1000.0);
		}
		else {
			out.print( '-');
		}
		out.fill( 20);
	}
}
