package asteroid.strategy.measure;

import asteroid.Operation;
import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.Ship;
import asteroid.model.TargetInfo;

public class Intersect extends AMeasure {
	private static final int MAX_ROT = 32;
	private double mFakt;
	private int mS0, mT0, mDv2;
	private Ship mShip;

	public Intersect( Ship ship, double fakt) {
		mShip = ship;
		mFakt = fakt;
	}

	protected void measure( AEnemy enemy) {
		TargetInfo info = enemy.getInfo();
		int dvx = enemy.getMoveX8() - Angle.vShotX( info.getDirection());
		int dvy = enemy.getMoveY8() - Angle.vShotY( info.getDirection());
		mDv2 = (dvx * dvx) + (dvy * dvy);
		if (mDv2 == 0) {
			mS0 = mT0 = -1;
			return;
		}
		int dx = Operation.signX8( enemy.getX8() - mShip.getX8());
		int dy = Operation.signY8( enemy.getY8() - mShip.getY8());
		int a = (dx * dvy) - (dy * dvx);
		mS0 = (int) Math.sqrt( (a * a / mDv2) + 0.5);
		if (mS0 > (mShip.size() + enemy.size() + 24)) {
			mS0 = mT0 = -1;
			return;
		}
		int b = (dx * dvx) + (dy * dvy);
		mT0 = -b / mDv2;
		if (mT0 < 0) {
			mT0 = -1;
			return;
		}
		if (mT0 > MAX_ROT) {
			return;
		}
		mT0 = MAX_ROT - mT0;
		enemy.mWeight -= mFakt * mDv2 * mT0;
	}

	protected void print( AEnemy enemy, PrintWriterFormat out) {
		out.print( mS0);
		out.print( ':');
		out.print( mT0);
		if (mT0 > 0) {
			out.print( ':');
			out.print( Math.round( -1000.0 * mFakt * mDv2 * mT0) / 1000.0);
		}
		out.fill( 20);
	}
}
