package asteroid.strategy.measure;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.TargetInfo;

public class RotTime extends AMeasure {
	private double mFakt;
	private Ship mShip;

	public RotTime( Ship ship, double fakt) {
		mShip = ship;
		mFakt = fakt;
	}

	protected void measure( AEnemy enemy) {
		TargetInfo info = enemy.getInfo();
		info.calculate( enemy, mShip, Angle.sDirection, GameModel.sFrame, GameModel.sFrame);
		int rot = info.getRot() + (16 * info.getWait());
		enemy.mWeight += mFakt * rot;
		if (info.getRot() == 0) {
			enemy.mWeight -= 90;
		}
	}

	protected void print( AEnemy enemy, PrintWriterFormat out) {
		TargetInfo info = enemy.getInfo();
		out.print( info.getRot());
		out.print( ':');
		out.print( info.getWait());
		out.fill( 10);
	}
}
